|
| These two routines are call compatable with svs's pascal
|
| sp -> return address
|       size (short for __NEW, long for __NEW4)
| result is placed in d0 before return (automatically by c code)
|
	.globl __NEW
__NEW:
	movl sp@+,savertn  | save return address, pop stack
	movw sp@+,d0       | save size requested, pop stack
	extl d0            | extend size
	moveml #0x14,sp@- | push state a3,a5
	movl d0,sp@-       | push size back onto stack
	jsr  malloc        | d0 should contain ptr to space on return
	addql #4,sp        | pop size off stack
	moveml sp@+,#0x2800 | pop state  a3,a5
	movl savertn,sp@-  | push return address
	rts

	.globl __NEW4
__NEW4:
	movl sp@+,savertn  | save return address, pop stack
	movl sp@+,d0       | save size requested, pop stack
	moveml #0x14,sp@- | push state a3,a5
	movl d0,sp@-       | push size back onto stack
	| The following is a hack that bypasses malloc for large chunks
	| as our malloc cannot do them -- our malloc will return NIL
	| for values of 64k or greater and dumps core with assertion
	| failure on values from 65515 to 64k - 1 inclusive.
	cmpl #65515,d0     | larger than malloc can handle?
	blt l1
	jsr  sbrk        | d0 should contain ptr to space on return
	bra l2
	| done with the hack, except for the following 2 labels
l1:	jsr  malloc        | d0 should contain ptr to space on return
l2:	addql #4,sp        | pop size off stack
	moveml sp@+,#0x2800 | pop state  a3,a5
	movl savertn,sp@-  | push return address
	rts
|
| These two routines are call compatable with svs's pascal
|
| sp -> return address
|       size (short for __DISP, long for __DISP4)
|       address being returned
| d0 is left with the size disposed of, and a0 the address

	.globl __DISP
__DISP:
	movl sp@+,savertn  | save return address, pop stack
	movw sp@+,d0       | save size requested, pop stack
	                   | note that svs puts the size in d0
	movl sp@+,a0       | save address of pointer to space being returned,
	                   | pop stack. note that svs puts the address in a0
	moveml #0x14,sp@- | push state a3,a5
	movl a0@,sp@-      | push address of space back onto stack
        clrl a0@           | nil the pointer to the space
 	jsr  free     
	addql #4,sp        | pop address off stack
	moveml sp@+,#0x2800 | pop state  a3,a5
	movl savertn,sp@-  | push return address
	rts

	.globl __DISP4
__DISP4:
	movl sp@+,savertn  | save return address, pop stack
	movl sp@+,d0       | save size requested, pop stack
	                   | note that svs puts the size in d0
	movl sp@+,a0       | save address of pointer to space being returned,
	                   | pop stack. note that svs puts the address in a0
	moveml #0x14,sp@- | push state a3,a5
	movl a0@,sp@-      | push address of space back onto stack
        clrl a0@           | nil the pointer to the space
	| The following 2 commands and label l3 implement the equivalent
	| check done in __NEW4 (above).  If we allocated with sbrk, then
	| we can't free the space.
	cmpl #65515,d0     | larger than malloc can handle?
	bge l3
  	jsr  free     
l3:	addql #4,sp        | pop address off stack
	moveml sp@+,#0x2800 | pop state  a3,a5
	movl savertn,sp@-  | push return address
	rts

	.globl __MARK
__MARK:
	jsr	abort

	.globl __RELSE
__RELSE:
	jsr	abort

	.data	
	savertn:.long 0
