#ifndef MEM_INTERNALS_INCL
#define MEM_INTERNALS_INCL
#include "../misc/platform.h"
#include "../bds/bds.s.h"


#ifdef S32
#define LOG2_WORDSIZE 1
typedef short WORD;
#endif
#ifdef SUN3
#define LOG2_WORDSIZE 1
typedef short WORD;
#endif
#if SUN4 || PMAX
/* WARNING!!! The following wordsize assumes that you do NOT allocate
   structures that contain 8-byte quantities (such as double reals).  If
   you DO use these then this allocator does not work for you. */
#define LOG2_WORDSIZE 2
typedef long WORD;
#endif
#ifdef VAX
#define LOG2_WORDSIZE 2
typedef long WORD;
#endif
#ifdef PC_AT
#define LOG2_WORDSIZE 2
typedef long WORD;
#endif

#define LOG2_SBRK_SIZE 15
#define LOG2_BLOCKSIZE 10

struct block {
    DR(main_arena, block);	/* links blocks in main arena */
    SL(arena, block);		/* links blocks in arenas */
    unsigned size;		/* size of entire block */
    unsigned free;		/* free space left at bottom */
    int allocated;              /* Size of original allocation if this
                                   block was created by a call to 
				   primary_alloc, rather than by mitosis.
				   (Thus it can be freed when pooling the 
				   entire main arena).  Otherwise 0.*/
    /* rest of space goes here -- size - (sizeof(struct block)) bytes */
};


struct element {
    SL(next, element);	/* link element in free list */
    unsigned size;	/* size of entire element */
    /* rest of space goes here -- size - (sizeof(struct element)) bytes */
};


struct main_arena {
    SH(free_blocks, block);
    SH(used_blocks, block);
};


#define POINTERS_PER_PBLOCK 32
#define INITIAL_UNUSED 0xFFFFFFFE /* last element marked used */
struct pointer_block {
    SR(next, pointer_block);
    unsigned long unused;
    char *pointers[POINTERS_PER_PBLOCK];
};


struct arena {
    struct block self;		/* allows arena to be treated as block */
    SH(blocks, block);		/* all blocks in arena (incl. itself) */
    SH(elements, element);	/* free elements */
    SHR(pointer_blocks, pointer_block);
    struct main_arena *main_arena;
    /* rest of space allocated for initial block */
    /* (this.size - sizeof(arena) bytes) */
};
#endif MEM_INTERNALS_INCL
