#include "../misc/platform.h"
#include <stdio.h>
#ifdef SUN
#define _NFILE 20
#endif SUN

#ifdef BSD42
#include <sys/time.h>
static struct itimerval shptick = { {0, 0}, {0, 0} };
static struct itimerval oshptick = { {0, 0}, {0, 0} };
#endif BSD42

#ifdef SYS5
#include <fcntl.h>


static int
dup2(i, j)
{
	(void)close(j);
	return fcntl(i, F_DUPFD, j);
}
#endif SYS5


static void
duplicate_fid(from_fid,to_fid,fmat,name)

int from_fid, to_fid;
char *fmat, *name;
{
     if ( dup2(from_fid,to_fid) == -1 ) {
          fprintf(stderr,fmat,name);
	  fflush(stderr);
	  _exit(1);
	  }
     close( from_fid );
}


int spawn(name,argv,envp,
          child_reads_from_pipe,child_writes_into_pipe,
	  prfd,pwfd)
			     /*returns the pid of the child spawned or
			       zero if error*/
char *name;                  /*file name to exec*/
char *argv[];                /*argument vector*/
char *envp[];                /*environment vector*/
int   child_reads_from_pipe; /*fid child expects to read parent msgs from*/
int   child_writes_into_pipe;/*fid child expects to use to write to parent */
int  *prfd;                  /*fid number parent should use to listen to child*/
int  *pwfd;                  /*fid number parent should use to speak to child*/
{
int child_process_id;
int parent_reads_from_pipe[2];
int parent_writes_into_pipe[2];
int fid={_NFILE};

   if (access(name,1) == -1) {
	fprintf(stderr,"Unable to execute '%s'.\n",name);
	fflush(stderr);
	return(0);
	}
   if (pipe(parent_writes_into_pipe) < 0)
	return(0);
   if (pipe(parent_reads_from_pipe) < 0) {
	close(parent_writes_into_pipe[0]);
	close(parent_writes_into_pipe[1]);
	return(0);
	}
   /*fprintf(stderr,"parent_writes: %d-%d parent_reads: %d-%d\n",
	           parent_writes_into_pipe[0],
	           parent_writes_into_pipe[1],
	           parent_reads_from_pipe[0],
	           parent_reads_from_pipe[1]);
   fflush(stderr);*/

   if ((child_process_id = fork()) == 0) { 
	do {
	   if ( !((fid == parent_writes_into_pipe[0]) ||
	          (fid == parent_reads_from_pipe[1]))    ) 
	        close(fid);
	   }
	   while ( --fid > 2 );

	if ( parent_writes_into_pipe[0] != child_reads_from_pipe) {
	     if ( child_reads_from_pipe == parent_reads_from_pipe[1] ) {
		  parent_reads_from_pipe[1] = dup(parent_reads_from_pipe[1]);
		  if (parent_reads_from_pipe[1] == -1) {
		       fprintf(stderr,"Unable to open communication to '%s'.\n",
				      name);
		       fflush(stderr);
		       _exit(1);
		       }
		  }
	     duplicate_fid( parent_writes_into_pipe[0],
			    child_reads_from_pipe,
		            "Unable to open communication to '%s'.\n",
			    name);
	     }

	if ( parent_reads_from_pipe[1] != child_writes_into_pipe) {
	     duplicate_fid( parent_reads_from_pipe[1],
			    child_writes_into_pipe,
		            "Unable to open '%s' communication to parent.\n",
			    name);
	     }


#ifdef BSD42
	/* the following turns off the timer used for profiling
	   since we are not profiling the child process, but the parent */

	setitimer(ITIMER_VIRTUAL, &shptick, &oshptick);
#endif BSD42

	execve(name,argv,envp);
	_exit(1);
	}

   registerchild(child_process_id);

   close( parent_writes_into_pipe[0] );
   close( parent_reads_from_pipe[1] );
   *prfd = parent_reads_from_pipe[0];
   *pwfd = parent_writes_into_pipe[1];
   return(child_process_id);
}
