#ifndef BDS_S_INCLUDED
#define BDS_S_INCLUDED

#include "avl.s.h"

/*            D A T A     S T R U C T U R E      M A C R O S                  */


/* The below lower-case macros create basic data structures
   consisting of clusters of variables which are one or
   more of: forward-pointer (fp), backward-pointer (bp) and head-pointer (hp)
   pointer-type variables which point to structures named with the
   macro options 'to' or 'list_of' (fp and bp) or 'grouped_in' (hp).
   NOTE: Their use in most cases requires a terminating semicolon. */

#define Xsh(to_type)struct to_type *fp
#define Xshr(to_type)struct to_type *tailp /* points to tail of singly linked ring */
#define Xdh(to_type)struct to_type *fp, *bp

#define Xsl(list_of_type)struct list_of_type *fpl
#define Xslh(list_of_type,grouped_in_type)\
Xsl(list_of_type); struct grouped_in_type *hp
#define Xsr(list_of_type)struct list_of_type *srp

#define Xdl(list_of_type)struct list_of_type *fpl, *bpl
#define Xdlh(list_of_type,grouped_in_type)\
Xdl(list_of_type); struct grouped_in_type *hp

#define Xdr(list_of_type)struct list_of_type *fp, *bp
#define Xdrh(list_of_type,grouped_in_type)\
Xdr(list_of_type); struct grouped_in_type *hp

#define Xptr(to_type)struct to_type *p

struct xshx  {Xsh(xshx);};
struct xdrhx {Xdrh(xdrhx,xdrhx);};
struct xptrx {Xptr(xptrx);};

#define SZ_SH (sizeof(struct xshx))
#define SZ_DRH (sizeof(struct xdrhx))
#define SZ_PTR (sizeof(struct xptrx))

/*----------------------------------------------------------------------------*/

/* The below upper-case macros each create a variable whose type is an
   untagged structure of a basic-data-structure, eg., SL creates a variable
   which is typed as a singly-linked-list.  The options to the macros
   begin with the name of the variable followed by the name of the structures
   to which the basic-data-structure members, eg., fp,bp,hp, are to point.
   NOTE: Their use in most cases requires a terminating semicolon. */

#define SH(variable,to_type)struct {Xsh(to_type);} variable
#define SHO SH
#define DH(variable,to_type)struct {Xdh(to_type);} variable
#define DHO DH

#define SHR(variable,to_type)struct {Xshr(to_type);} variable

#define SL(variable,list_of_type)struct {Xsl(list_of_type);} variable
#define SLH(variable,list_of_type,grouped_in_type)\
struct {Xslh(list_of_type,grouped_in_type);} variable
#define SLO SL
#define SLHO SLH

#define SR(variable,list_of_type)struct {Xsr(list_of_type);} variable
#define SRO SR

#define DL(variable,list_of_type)struct {Xdl(list_of_type);} variable
#define DLO DL
#define DLH(variable,list_of_type,grouped_in_type)\
struct {Xdlh(list_of_type,grouped_in_type);} variable
#define DLHO DLH

#define DR(variable,list_of_type)struct {Xdr(list_of_type);} variable
#define DRO DR
#define DRH(variable,list_of_type,grouped_in_type)\
struct {Xdrh(list_of_type,grouped_in_type);} variable
#define DRHO DRH

#define PTR(variable,to_type)struct {Xptr(to_type);} variable
#define PTRO PTR

#define INORDER_STACK_WORK_SIZE (sizeof(int)*8)
#define INORDER_STACK(name,tree_type)\
struct name {\
	    int entries;\
	    struct {\
		   tree_type *ptr;\
		   int path;\
		   } Xavlstack[INORDER_STACK_WORK_SIZE];\
	    } name

#define INORDERO_STACK INORDER_STACK

#endif BDS_S_INCLUDED
