#ifndef AVL_S_INCLUDED
#define AVL_S_INCLUDED

/*            D A T A     S T R U C T U R E      M A C R O S                  */

#if defined(convex) || defined(vax) || defined(VAX)
/* Make sure that the memory allocator insures 4-byte boundaries!! */
#define Xavlleft  0x1
#define Xavlequal 0x0         /* 0 since initialization wants equal balance */
#define Xavlright 0x2

#define AVL_BALANCE 0x3
#else
/* Make sure that pointers don't use the 2 most significant bits!! */
#define Xavlleft  0x40000000
#define Xavlequal 0x0         /* 0 since initialization wants equal balance */
#define Xavlright 0x80000000

#define AVL_BALANCE 0xC0000000
#endif

#define Xavllsp(p,type)     ((type *)((int)(p)&(~AVL_BALANCE)))
#define Xavlbd(p)           ((int)(p)&AVL_BALANCE)
#define _Xavllsps(p,np,type) (p=(type *)(Xavlbd(p) |(int)Xavllsp(np,type)))
#define Xavlbds(p,bd,type)  (p=(type *)((int)Xavllsp(p,type)|Xavlbd(bd)))
#ifdef DEBUGI
#define Xavllsps(p,np,type) (AS(!((int)(np)&AVL_BALANCE)),_Xavllsps(p,np,type))
#else
#define Xavllsps(p,np,type) _Xavllsps(p,np,type)
#endif DEBUGI


#define Xavlr(tree_type)\
	       struct tree_type *root

#define Xavl(tree_type,avl_key)\
	      struct tree_type *lsp, *fp;\
	      avl_key key
/* bd is the balance-depth at a node, i.e. bd=right meens that the right son
   is deeper than the left son.  It is coded in the upper bits of lsp */

#define Xavlh(tree_type,avl_key,root_type)\
	      Xavl(tree_type,avl_key);\
	      struct root_type *hp


#define AVLR(variable,tree_type)struct {Xavlr(tree_type);} variable
#define AVLRO AVLR
#define AVL(variable,tree_type,avl_key)\
	                   struct {Xavl(tree_type,avl_key);} variable
#define AVLO AVL
#define AVLH(variable,tree_type,avl_key,root_type)\
	                 struct {Xavlh(tree_type,avl_key,root_type);} variable
#define AVLHO AVLH
#define AVL_KEY(rec_avl,rec) (rec->rec_avl.key)
#define AVLH_KEY AVL_KEY

/* Note: AVLWORK defines a work area for avl tree traversal. 
         AVL_WORK_SIZE should be larger than the expected depth of the tree,
	 here set to the number of bits in a long
*/

#define AVL_WORK_SIZE (sizeof(long)*8)
#define AVLWORK struct Xavlwork {\
	              int entries;\
	              struct {\
		             struct Xavlwork *ptr;\
		             int which_way;\
		             } Xavlstack[AVL_WORK_SIZE];\
	              } Xavlwork={AVL_WORK_SIZE}

#endif
