.DS L
.PV
#ifndef ER_TABLE_H
#define ER_TABLE_H
#include "Clib/stringt.h"
#include "entry.h"
#include "special.h"
class erule_special;

gavl_define(_name,erule_interesting_extension,string);
class erule_interesting_extension {
    gavl_inst(_name,erule_interesting_extension,string);
public:
    erule_interesting_extension(const string&);
    const string& name() { return _name; }
};
gavl_inline(_name,erule_interesting_extension,string);

.EP

.BC
Table of expansion rules.
It reads definition files and selects version
based on instance-dependent context and global text-macro tables.
Currently, only one compile-type is interesting at a time.
Intended for internal use only.
.EC
class erule_table {
.PV
    erule_entry* _entry; // Just one for now -- corresponds to compile type
    string _compile_type;
    gringroot(_next,erule_special) specials;
    erule_special* special_iterator;
    gavlroot(_name,erule_interesting_extension,string) interesting_extensions;
.EP
public:
    erule_table(const string& compile_type);
    ~erule_table() { fault("~erule_table()"); }

    void enter_special(const string&);
    void make_extension_interesting(const string&);
    boolean extension_is_interesting(const string&);
    boolean read(const string& filename);

    erule_special* find_special(const string&);
    erule_special* first_special(); // non-reentrant iterator
    erule_special*  next_special();
    erule_entry* enter() { return _entry; }
    erule_entry* enter(const string& comp_type)
	{ return comp_type == _compile_type ? _entry : 0; }

    void dump(ostream&);
};

extern erule_table* erule_the_rule_table;
.PV

inline erule_special* erule_table::first_special()
    { return (special_iterator = specials.first()); }

inline erule_special* erule_table::next_special()
    { return (special_iterator = specials.next(special_iterator)); }

#endif
.EP
.DE
