#include "dwg_extension.h"
#include "dwg_special.h"
#include "extension.h"
#include "table.h"
#include "lex.h"
#include "add/v_add.h"


#ifdef VAX
gring_functions(next,erule_extension,);
#endif


// Initialized below by their users -- these can't be staticly initialized,
// as they depend on the prior initialization of the string table.
static string PRIM;
static string PART;
static string SPECIAL;
static string PRIMITIVE;
static string LOGIC;
static void order_dependent_static_init()
{
#   define init(s) s = "s"
    init(PRIM);  init(PART);  init(SPECIAL);  init(PRIMITIVE);  init(LOGIC);
#   undef init
}


// Output must be SCALD-parseable (assume that name is an identifier)
ostream& operator<<(ostream& o, const erule_extension& e)
{
    switch (e._kind) {
    case DRAWING_EXTENSION:
	o << e.name;  break;
    case OTHER_PRIM_EXTENSION:
	o << e.name << "(PRIMITIVE)";  break;
    case SCALD_PRIM_EXTENSION:
	o << "PRIM(" << e.name << ")";  break;
    case UNKNOWN_EXTENSION:
    default:
	o << "{ unknown }BOGUS99999999";  break;
    case SPECIAL_EXTENSION: 
	o << e.name << "(SPECIAL)";  break;
    }
    return o;
}


boolean operator==(const erule_drawing_extension& de, const erule_extension& e)
{
    switch (e._kind) {
    case DRAWING_EXTENSION:
    case OTHER_PRIM_EXTENSION:
        return de._name == e.name;
    case SCALD_PRIM_EXTENSION:
	{
	    string dirtype =  de.scald_directory.type();
	    return dirtype == e.name && de.is_prim();
	}
    case UNKNOWN_EXTENSION:
    default:
	fault("comparing unknown extension kind");
    case SPECIAL_EXTENSION:
        return FALSE;
    }
}


boolean operator==(const erule_drawing_special& sp, const erule_extension& e)
{
    return e._kind == SPECIAL_EXTENSION ? sp._name == e.name : FALSE;
}


erule_extension::erule_extension(const string& nm, const string& attribute)
{
    AS(!this);
    this = (erule_extension*)erule_heap.mem(sizeof(*this));
    
    if (!nm) fault("null name to erule_extension::erule_extension()");

    if (!PRIM) order_dependent_static_init();

    if (nm == PART || nm == PRIM) {
        _kind = SCALD_PRIM_EXTENSION;
	name = attribute;
        if (!attribute) 
	    fault("Expected extension and attribute to be correct here");
	s_consider_type(name);
    }
    else {
	_kind = DRAWING_EXTENSION;
	name = nm;
	if (attribute)
	    if (attribute == SPECIAL) {
		_kind = SPECIAL_EXTENSION;
		erule_the_rule_table->enter_special(name);
	    }
	    else if (attribute == PRIMITIVE) _kind = OTHER_PRIM_EXTENSION;
	    else fault("Expected extension and attribute to be correct here");
	if (_kind == DRAWING_EXTENSION)
	    erule_the_rule_table->make_extension_interesting(name);
    }
}


// Parse extension_spec ::= PRIM ( extension ) | extension attribute_spec
//       extension ::= identifier
//       attribute_spec ::= ( SPECIAL ) | ( PRIMITIVE ) | null
// Return erule_extension created by the result.  Report errors as parse
// errors.  Return *ok = TRUE iff no errors.
erule_extension::erule_extension(erule_lex* lex, const erule_entry* parent,
    boolean* ok /* returned */)
{
    if (!PRIM) order_dependent_static_init();

    AS(!this);
    this = (erule_extension*)erule_heap.mem(sizeof(*this));

    *ok = TRUE;
#   define ERROR(errnum) (lex->error(errnum), *ok=FALSE)

    AS(*lex == LEX_ID);

    string extension = lex->val();
    if (extension == PRIM || extension == PART) {
	_kind = SCALD_PRIM_EXTENSION;
        if (parent) 
	    name = parent->compile_type();	// pre-emptive error handling
	else name = LOGIC;
    }
    else {
	_kind = DRAWING_EXTENSION;
	name = extension;
    }

    lex->next_token();

    if (*lex == LEX_LPAREN) {
	lex->next_token();
	if (*lex != LEX_ID) ERROR(ERR_EXP_ID);
	else {
	    string attribute = lex->val();
	    if (_kind == SCALD_PRIM_EXTENSION)
		if (attribute == PRIM || attribute == PART)
		    ERROR(ERR_PRIM_IS_ILLEGAL_DIR_TYPE);
                else name = attribute;
	    else if (attribute == SPECIAL) {
		_kind = SPECIAL_EXTENSION;
		erule_the_rule_table->enter_special(name);
	    }
	    else if (attribute == PRIMITIVE) _kind = OTHER_PRIM_EXTENSION;
	    else ERROR(ERR_EXP_SPECIAL_OR_PRIMITIVE);
	    lex->next_token();
	}
	if (*lex != LEX_RPAREN) ERROR(ERR_EXP_RPAREN);
	else lex->next_token();
    }
    else if (extension == PRIM || extension == PART)
	ERROR(ERR_PRIM_REQUIRES_ATTRIBUTE);
    if (_kind == SCALD_PRIM_EXTENSION) s_consider_type(name);
    if (_kind == DRAWING_EXTENSION)
	erule_the_rule_table->make_extension_interesting(name);
}

