\" This is the template for the release documentation
\"
\" You need to fill in the following 4 lines with your
\" package name, version string, number of blocks, and
\" Installation format (generally Vinstall or VMSinstall).
\" Then fill in the necessary paragraphs.

.ds PN ValidCOMPILER
.ds VR 1.4 VMS-P3
.ds OV 1.4 VMS-P1
.ds BL 5553
.ds IF VMSinstall

.ds CF \*(PN   Version \*(VR
.sp 20
.TL
Release Notice
.sp 12
.LG
.LG
\*(PN
.SM
.SM
.sp 3
Version \*(VR
.sp 3
\*(BL Blocks
.sp 4
\*(IF Installation Format
.sp 15
.AU
.LG
Valid Logic Systems Incorporated
.SM
.AE
.bp
.nr PS 12
.nr VS 14
.NH 1
Introduction
.LP

The \fBValidCOMPILER\fP converts a design, which may be hierarchical,
into a flat netlist usable by verification tools.  It detects and reports
errors in the use of the \fBSCALD III\fP schematic language.
.NH 1
Changes in Version \*(VR
.LP
There are no new features.
The following bugs have been fixed over version \*(OV
.IP *
The list file emitted by the linker is not truncated properly when overwritten, thus
old error messages may follow the "end" of the current linker list file, causing
confusion.
.IP *
ERROR(253) is emitted incorrectly when an ill-formed cardinal bit tap
is encountered.  The correct error to emit is ERROR(69).
.IP *
ValidCOMPILER does not properly handle PRIMs with context sensitivity
(such as selection expressions).   Alternate compilations yield correct 
results.   STARS 1958.
.IP *
Assertion check violation 154 occurs when an identifier is defined as both
a parameter and a local text macro for the same drawing.  NOTE: this has
been fixed so that the parameter definition overrides the local text macro.
This allows local text macros to be used to define default values for
parameters on a drawing-by-drawing basis.
.IP *
Drawing contains PART.1.1, SIM.1.1 and SIM.2.1.  When compiling for logic,
page compiler quits with message "menu version isn't first in list".
STARS 26852.
.NH 1
Dependencies
.LP
Library installation resulting in the existence of the files
scald$root[language]config.dat and scald$root[libraries]master.lib.
\fBGed\fP installation -- \fBged\fP drawings are the \fBValidCOMPILER\fP's
primary input.
.NH 1
Known Problems in Version \*(VR
.LP
.IP *
When SCALD directories are moved and have had shadow directories created
by the system, then the system will create new shadow directories for
the "new" SCALD directories without deleting the ones created for the old
directories.
.IP *
The linker will not report signals synonymed to their own complement.
The SCALD compiler reports these as ERRORs and the ValidCOMPILER should
do likewise.
.IP *
Errors in processing compiler directives and the "path name exceeds 
maximum length"
error (when generated by the linker)
are generated when no list file is open and thus do not make it into the
cmplst.dat file.  Directives errors are reported to the monitor and to
cmplog.dat.  The "path name exceeds maximum length" error when generated by 
the linker is reported only to the monitor and does not stop the host
tool (ValidCOMPILER, ValidSIM, etc.) from proceeding, 
though its results will be erroneous.  This occurs
because the error is detected while the design is being communicated to
the host tool (other errors being detected before this phase).
Note that this error
occurs \fBextremely\fP rarely -- only in cases of \fBvery\fP
deep hierarchy and 
only when the host program was written in PASCAL (as was ValidSIM).
.IP *
The compiler does not detect changes to property attributes 
(such as making a property INHERIT(PIN) where before it was not) when
deciding whether to recompile a page.  
(Property attributes describe how a property can be used, not what
its value is -- see the ValidCOMPILER manual for a full description.)
This kind of change is usually
made very infrequently.
If changes of this kind are made, then
all old page compiler results must be removed by deleting the shadow 
directories that have been used to hold them.
(If shadow directories have not been explicitly specified, then
"delete [.xshadowx...]*.*;*" will work just fine when executed from the directories
in which compilation has been done.  It may leave directories lying around, but this
is harmless.)
.NH 1
Installation and Configuration
.LP
Use vmsinstall. 
.NH 1
Documentation
.LP
Please refer to the ValidCOMPILER Manual and the SCALD III Language manual.
