if [ $# -lt 4 ]
then
    cat <<END_USAGE 1>&2
Usage: $0 kit major_version platform-minor_version release_subdir ...
       It is expected that release document \$release_subdir.ms exsists.
       Arguments following release_subdir are other files to be copied
END_USAGE
    exit 1
fi

package=$1
shift
major=$1
shift
plat_and_minor=$1
shift
release_subdir=$1
shift


MS=$package.$major.$plat_and_minor.ms
V=$package.$major.$plat_and_minor.v


if [ ! "$RELEASE_ROOT" ]
then
    RELEASE_ROOT=/valid/release
fi


if mkinstall -f $V
then
    :
else
    exit 1
fi
rm -f $MS
ln -s $release_subdir.ms $MS
if echo $RELEASE_ROOT | fgrep ":"
then
    echo rcp $V $MS $* $RELEASE_ROOT/$release_subdir/kits/compiler
    rcp $V $MS $* $RELEASE_ROOT/$release_subdir/kits/compiler
else
    echo cp $V $MS $* $RELEASE_ROOT/$release_subdir/kits/compiler
    cp $V $MS $* $RELEASE_ROOT/$release_subdir/kits/compiler
fi

