
function avl_compare(obj1, obj2: avl_object_ptr; kind: avl_type): compare_type;
  { compare the 2 avl objects as appropriate for their type }
begin
#if AVLDEBUG
  if not ((obj1.tag = obj2.tag) and (obj2.tag = kind)) then    
    begin                                                      
      assert(245 }(* uncool*) );                               
      avl_compare := LT;                                       
    end                                                        
  else                                                         
#endif
    case kind of

    { ---------  Compare complemented actuals (signal definitions)--------}

      AVL_COMPLEMENTED_ACTUAL:
        { This tree consists of signal definitions for signals with
	  complemented polarity.  Lookups may compare them with 
	  their uncomplemented counterpart, so comparisons must be based on
	  signal definition NAMES (ignoring the polarity).  These names are
	  all in the string table, so the comparison can be done on the
	  pointer or char-by-char. }
        if obj1.complemented_actual = NIL then
	  if obj2.complemented_actual = NIL then avl_compare := EQ
	                                    else avl_compare := LT
	else if obj2.complemented_actual = NIL then avl_compare := GT
        else if obj1.complemented_actual^.signal^.name =
	        obj2.complemented_actual^.signal^.name then avl_compare := EQ
	else
	  case compare_strings(obj1.complemented_actual^.signal^.name,
	                       obj2.complemented_actual^.signal^.name) of
            LT: avl_compare := LT;
	    GT: avl_compare := GT;
	    EQ:
	      begin
	        assert(246 { Equal strings have unequal pointers });
		avl_compare := EQ;
	      end;
          end;

    { ---------------- end of legitimate avl types -----------------------}

      OTHERWISE
        begin
          assert(244 { not allowed });
          avl_compare := LT;
        end;
    end;
end { avl_compare } ;
