| handler_wrap(entry_point, static_link)
|	void (*entry_point)(); /* address of PASCAL interrupt handler */
|	char *static_link;     /* static link for interrupt handler */
|
| handler_wrap1(entry_point, static_link, parameter)
|	void (*entry_point)(); /* address of PASCAL interrupt handler */
|	char *static_link;     /* static link for interrupt handler */
|	char *parameter;       /* 4-byte parameter to be passed up */
|
| savea4a5()
|
| handler_wrap calls a parameterless PASCAL routine passed by reference, 
| setting up the specified static link.  
| savea4a5 is an initialization routine that should be called prior to
| handler_wrap, and while the registers a4 and a5 still contain their
| PASCAL values.  Since this call is expected to be made from an
| asynchronously called C function, it is necessary to be overly
| conservative in managing the runtime enrivonment. (See note below).
|
|
| handler_wrap1 is the same except that it passes 1 parameter.
|
| This code is a modified version of code that was stolen from Ron
| Ellickson, convert program, 860801.  The following note is from that
| code.
|
| In order to call Pascal from C, note that:
|	** Pascal doesn't save %d2 -- it assumes that it's a scratch% --
|	this makes C sick.
|	** Pascal uses %a4 and %a5 for global base pointers. %a4 is used
|	to index a dispatch table for subroutine linkage; %a5 is used
|	as a base pointer to the big Pascal common block.  We have to
|	load these registers before entering Pascal, then restore them
|	on return.
|	The "module at a time" compilers don't require this nonsense, since
|	they give real names to all globally-known objects.
|
|
	.text
        .globl savea4a5
savea4a5: movl a4,pas_a4    | save a4
	movl a5,pas_a5      | save a5
	rts
	.data
pas_a4: .long 0
pas_a5: .long 0
	.text
        .globl handler_wrap
handler_wrap:
	link a6,#-12		| for the debuggers
        movl d2,a6@(-4)		| save d2
        movl a4,a6@(-8)		| save a4
        movl a5,a6@(-12)	| save a5
	movl pas_a4,a4		| Pascal dispatch base
	movl pas_a5,a5		| Pascal common-block base
	movl a6@(12),sp@-	| Push the static link of PASCAL handler
	movl a6@(8),a0          | Address of PASCAL interrupt handler
	jsr  a0@                | Call PASCAL interrupt handler
	movl a6@(-4),d2		| restore d2
	movl a6@(-8),a4		| restore a4
	movl a6@(-12),a5	| restore a5
	unlk a6
	rts			| done.
        .globl handler_wrap1
handler_wrap1:
	link a6,#-12		| for the debuggers
        movl d2,a6@(-4)		| save d2
        movl a4,a6@(-8)		| save a4
        movl a5,a6@(-12)	| save a5
	movl pas_a4,a4		| Pascal dispatch base
	movl pas_a5,a5		| Pascal common-block base
	movl a6@(16),sp@-	| Push the parameter
	movl a6@(12),sp@-	| Push the static link of PASCAL handler
	movl a6@(8),a0          | Address of PASCAL interrupt handler
	jsr  a0@                | Call PASCAL interrupt handler
	movl a6@(-4),d2		| restore d2
	movl a6@(-8),a4		| restore a4
	movl a6@(-12),a5	| restore a5
	unlk a6
	rts			| done.
