\" This is the template for the release documentation
\"
\" You need to fill in the following 4 lines with your
\" package name, version string, number of blocks, and
\" Installation format (generally Vinstall or VMSinstall).
\" Then fill in the necessary paragraphs.

.ds PN ValidCOMPILER
.ds VR 1.4 S32-P1
.ds OV 1.3 S32-P6
.ds BL 4500
.ds IF Vinstall

.ds CF \*(PN   Version \*(VR
.sp 20
.TL
Release Notice
.sp 12
.LG
.LG
\*(PN
.SM
.SM
.sp 3
Version \*(VR
.sp 3
\*(BL Blocks
.sp 4
\*(IF Installation Format
.sp 15
.AU
.LG
Valid Logic Systems Incorporated
.SM
.AE
.bp
.nr PS 12
.nr VS 14
.NH 1
Introduction
.LP

The \fBValidCOMPILER\fP converts a design, which may be hierarchical,
into a flat netlist usable by verification tools.  It detects and reports
errors in the use of the \fBSCALD III\fP schematic language.
.NH 1
Changes in Version \*(VR
.LP
Table-driven expansion control has been added.  This facilitates library
development and the use of multiple types of models with the same analysis
tool (such as a mixed-mode simulation).

Support for bit taps which interpret the specified bits as cardinal numbers.

This version will initially recompile all pages to insure that all bug
fixes are reflected in your results.

The following bugs have been fixed over version \*(OV
.IP *
Primitives that contain text-macro invocations dependent on parameterization
are not correctly handled unless an EXPR property is present.  (Workaround
is to put EXPR=TRUE on the drawing body.)
.IP *
ValidCOMPILER does not run on CVAX due to changes to VAXC/VMS interface.
.IP *
Page compiler will occassionaly mangle the name of a SCALD directory
and then complain about not finding it.  { UNIX only. }
.IP *
Linker generates assertion check failure "Page already exists" and
then exits when compiler compiles a drawing with many (and/or long-valued)
parameters. (That is, that parameter names and values concatenated 
together produces a long string.)
.IP *
Some designs with interface signals synonymed together AND interface
signals synonymed to globals will cause the linker to fail with
the message "Global-tie insertion fails".  STARS 1574.
.IP *
Linker fails to report synonyming together 2 signals with name properties
(timing verifier assertions).
.IP *
Can't turn off creation of cmpexp.dat with OUTPUT directive.
STARS 1564.
.IP *
Infinite loop in SCALD compiler ERROR_HELP processing.  STARS 1659.
.IP *
OVERSIGHT 176 not documented in ERROR_HELP output.  STARS 1820.
.IP *
Compiler issues no error when SIG_NAME is improperly connected to
something by the user.  STARS 1866.
.IP *
Compiler doesn't report pin that's a subrange of another pin as
an error -- linker then dumps core.  STARS 1780.
.NH 1
Dependencies
.LP
Library installation resulting in the existence of the files
/u0/scald/config.dat and /u0/lib/master.lib.
\fBGed\fP installation -- \fBged\fP drawings are the \fBValidCOMPILER\fP's
primary input.
.NH 1
Known Problems in Version \*(VR
.LP
.IP *
The file-locking mechanism works only locally. If 2 users on different
machines compile the same drawing simultaneously and write to the same
(NFS-mounted) shadow directory collisions may result.  Using only local
shadow directories will prevent this occurrence entirely.
.IP *
When SCALD directories are moved and have had shadow directories created
by the system, then the system will create new shadow directories for
the "new" SCALD directories without deleting the ones created for the old
directories.
.IP *
The linker will not report signals synonymed to their own complement.
The SCALD compiler reports these as ERRORs and the ValidCOMPILER should
do likewise.
.IP *
Errors in processing compiler directives and the "path name exceeds 
maximum length"
error (when generated by the linker)
are generated when no list file is open and thus do not make it into the
cmplst.dat file.  Directives errors are reported to the monitor and to
cmplog.dat.  The "path name exceeds maximum length" error when generated by 
the linker is reported only to the monitor and does not stop the host
tool (ValidCOMPILER, ValidSIM, etc.) from proceeding, 
though its results will be erroneous.  This occurs
because the error is detected while the design is being communicated to
the host tool (other errors being detected before this phase).
Note that this error
occurs \fBextremely\fP rarely -- only in cases of very deep hierarchy and 
only when the host program was written in PASCAL.
.IP *
The compiler does not detect changes to property attributes 
(such as making a property INHERIT(PIN) where before it was not) when
deciding whether to recompile a page.  
(Property attributes describe how a property can be used, not what
its value is -- see the ValidCOMPILER manual for a full description.)
This kind of change is usually
made very infrequently.
If changes of this kind are made, then
all old page compiler results must be removed by deleting the shadow 
directories that have been used to hold them.
(If shadow directories have not been explicitly specified, then
"rm -r xshadowx" will work just fine when exectued from the directories
in which compilation has been done.)
.NH 1
Installation and Configuration
.LP
Use vinstall.
.NH 1
Documentation
.LP
Please refer to the ValidCOMPILER Manual and the SCALD III Language manual.
Details of the expansion control and bit tap features are described in the
attached ERSes.
.ps
