#define MAXCHILD	10

struct waitinfo
{
	int		pid;
	int 		status;
};

static struct waitinfo waittab[MAXCHILD];
static pidtab[MAXCHILD];

/*
** Provide multiplexed access to wait(2).
** Keep it general enough to work in 4.2 and System 5.
**
** Use:
**	Call these functions only if your program does not
**	use the SUN notifier.
**
**	Call registerchild() with the PID of every child that
**	you spawn, immediately after you spawn it.
**
**	Call waitfor() with the PID of the child you wish to reap.
**	The semantics are the same as wait(2).
**
** Restrictions:
**	Do not use system(3), and other routines which fork(2), in your
**	program.  Routines such as system(3) may spawn children
**	while ignoring the above conventions. This will cause a
**	fatal error if the routines below reap one of these
**	unregistered children.
*/

int waitfor(pid, status)
int pid;
int *status;
{
	register i;
	char *err = "internal error: wait table overflow\n";
	char *err2 = "internal error: waitfor: reap unregistered child\n";

	for (i=MAXCHILD; i-- ;)
	{
		if (waittab[i].pid == pid)
		{
			if (status)
				*status = waittab[i].status;

			waittab[i].pid = 0;
			return(pid);
		}
	}

	for (i=MAXCHILD; i-- ;)
	{
	   if (waittab[i].pid == 0)
	   {
		int n;

		if ((waittab[i].pid = wait(&(waittab[i].status))) == -1)
		{
			if (status)
				*status = waittab[i].status;

			waittab[i].pid = 0;
			return(-1);
		}

		for (n=MAXCHILD; n-- ;)
		{
			if (pidtab[n] == waittab[i].pid)
			{
				pidtab[n] = 0;
				return(waitfor(pid, status));
			}
		}

		write(2, err2, strlen(err2));
		exit(-1);
	   }
	}

	write(2, err, strlen(err));
	exit(-1);
}

registerchild(pid)
{
	register i;
	char *err = "internal error: wait pid table overflow\n";

	for (i=MAXCHILD; i-- ;)
	{
		if (pidtab[i] == 0)
		{
			pidtab[i] = pid;
			return;
		}
	}

	write(2, err, strlen(err));
	exit(-1);
}
