const
  id_length = 16;
  max_string_length = 255;
type
  string_range  = 0..max_string_length;
  char_array = packed array[string_range] of char;
  sstring = ^char_array;
  id_range = 1..ID_LENGTH;                    { range of an identifier }
  alpha = packed array [id_range] of char;    { identifier type }

function alpha_length(*name: alpha): id_range*);
  { find the length of an identifier by scanning for its end }
  var
    i: id_range;         { index into the identifier }
    done: boolean;       { TRUE when end of alpha found }
begin
  i := ID_LENGTH;  done := FALSE;
  while (i > 1) and not done do
    if name[i] <> ' ' then done := TRUE else i := i - 1;

  alpha_length := i;
end { alpha_length } ;


procedure new_free_element(var f: freeptr);
  { create a new free element for released strings }
begin
  new(f);
  increment_heap_count(HEAP_FREEELEMENT, 2*POINTER_SIZE);
  f^.next := NIL;
  f^.str := NIL;
end { new_free_element } ;


procedure create_a_string(var str: xtring; length: string_range);
  { Create a string on the heap of the given length.  This routine uses a
    variant record to represent strings of various lengths with one
    pointer.  First, the free lists are checked for a string of the
    appropriate length.  If none are available, a string is newed from
    the heap.  This scheme works only if the Pascal compiler creates only
    as much space as needed for a variant when the tag field is specified
    in the new.  }
  type
    size_type = (s4,s8,s12,s16,s20,s24,s28,s32,s36,s40,s44,
                 s48,s52,s56,s60,s64,s68,s72,s76,s80,s84,s88,
                 s92,s96,s100,s120,s140,s160,s180,s200,s220,s240,s256);

    trick_ptr = ^trick_record;
    trick_record = record case size_type of
                     s4: (f4: packed array [0..3] of char);
                     s8: (f8: packed array [0..7] of char);
                     s12: (f12: packed array [0..11] of char);
                     s16: (f16: packed array [0..15] of char);
                     s20: (f20: packed array [0..19] of char);
                     s24: (f24: packed array [0..23] of char);
                     s28: (f28: packed array [0..27] of char);
                     s32: (f32: packed array [0..31] of char);
                     s36: (f36: packed array [0..35] of char);
                     s40: (f40: packed array [0..39] of char);
                     s44: (f44: packed array [0..43] of char);
                     s48: (f48: packed array [0..47] of char);
                     s52: (f52: packed array [0..51] of char);
                     s56: (f56: packed array [0..55] of char);
                     s60: (f60: packed array [0..59] of char);
                     s64: (f64: packed array [0..63] of char);
                     s68: (f68: packed array [0..67] of char);
                     s72: (f72: packed array [0..71] of char);
                     s76: (f76: packed array [0..75] of char);
                     s80: (f80: packed array [0..79] of char);
                     s84: (f84: packed array [0..83] of char);
                     s88: (f88: packed array [0..87] of char);
                     s92: (f92: packed array [0..91] of char);
                     s96: (f96: packed array [0..95] of char);
                     s100: (f100: packed array [0..99] of char);
                     s120: (f120: packed array [0..119] of char);
                     s140: (f140: packed array [0..139] of char);
                     s160: (f160: packed array [0..159] of char);
                     s180: (f180: packed array [0..179] of char);
                     s200: (f200: packed array [0..199] of char);
                     s220: (f220: packed array [0..219] of char);
                     s240: (f240: packed array [0..239] of char);
                     s256: (f256: packed array [0..255] of char);
                    end;
var
  k: record case boolean of      { "trick" record to fiddle with pointers }
       TRUE:  (tp: trick_ptr);
       FALSE: (ap: xtring);
     end;
  p: trick_ptr;                  { pointer to the created string }
  fp: freeptr;                   { pointer to head of free strings }
  size: 1..33;                   { the size (index into table) of string }

begin
  if length > 100 then size := ((length+1)+420) DIV 20
                  else size := ((length+1) DIV 4) + 1;
  if free_strings[size] <> NIL then
    begin
      str := free_strings[size]^.str;
      fp := free_strings[size]^.next;
      free_strings[size]^.next := free_pointers;
      free_pointers := free_strings[size];
      free_strings[size] := fp;
    end
  else
    begin
      case s_length[size] of
          4: new(p,s4);
          8: new(p,s8);
         12: new(p,s12);
         16: new(p,s16);
         20: new(p,s20);
         24: new(p,s24);
         28: new(p,s28);
         32: new(p,s32);
         36: new(p,s36);
         40: new(p,s40);
         44: new(p,s44);
         48: new(p,s48);
         52: new(p,s52);
         56: new(p,s56);
         60: new(p,s60);
         64: new(p,s64);
         68: new(p,s68);
         72: new(p,s72);
         76: new(p,s76);
         80: new(p,s80);
         84: new(p,s84);
         88: new(p,s88);
         92: new(p,s92);
         96: new(p,s96);
        100: new(p,s100);
        120: new(p,s120);
        140: new(p,s140);
        160: new(p,s160);
        180: new(p,s180);
        200: new(p,s200);
        220: new(p,s220);
        240: new(p,s240);
        256: new(p,s256);
      end;
      k.tp := p;  str := k.ap;
      increment_heap_count(HEAP_STRING, s_length[size]);
    end;
  str^[0] := chr(length);
end { create_a_string } ;


procedure release_string(var str: xtring);
  { free the storage used by the given string and place on free list }
  var
    size: string_range;     { size (index into table) of the string }
    f: freeptr;             { head of list of free strings }
begin
  if str <> nullstring then
    begin
      if ord(str^[0]) > 100 then size := (ord(str^[0])+420) DIV 20
                            else size := (ord(str^[0]) DIV 4) + 1;
      if free_pointers = NIL then new_free_element(f)
      else
        begin f := free_pointers; free_pointers := free_pointers^.next; end;
      f^.next := free_strings[size];
      free_strings[size] := f;  f^.str := str;
      str := nullstring;
    end;
end { release_string } ;


procedure copy_to_string(name: alpha;  var str: xtring);
  { copy from an alpha to a string.  Trailing blanks are deleted. }
  var
    len: id_range;    { length of the identifer }
    i: id_range;      { index into alpha and string for copy }
begin
  len := alpha_length(name);

  if ord(str^[0]) <> len then 
    begin  release_string(str);  create_a_string(str, len);  end;
  for i := 1 to len do  str^[i] := name[i];
end { copy_to_string } ;


begin
  foo := copy_to_string('REP="%1"        ');
end.
