function init_next_page: boolean;
  { Set up next page for compilation.
    Return TRUE if one is needed, FALSE if completely done with all pages
    (of this type (?) applying to the specified context).
    Guarantee the following state when TRUE is returned:
      1. CmpExp has been opened for writing.
      2. If PrintCmpLst then the CmpLst file has been opened for writing. 
      3. paged_schema_of_this_page has been initialized. }
  var
    make_it: boolean;     { TRUE until we find out we either can't make the
                            page or we don't need to }
    done: boolean;        { TRUE when we find or insert paged schema in loop }
    is_new_page: boolean; { TRUE iff entered page is a new page }
    context_description: xtring;


begin { init_next_page }
  if debug_20 then writeln(outfile, 'enter init_next_page');
  make_it := FALSE;
  repeat
    if page_being_compiled = 0 then 
      begin
        if make_pass = MAKE_PASS_2 then clear_errors;

        {  start at first page }
	
        page_being_compiled := er_page(module_being_compiled);
        if page_being_compiled = 0 then
          begin
            if make_pass = MAKE_PASS_2 then
              begin
                assert(229 { version with no pages - should be impossible });
                error(217 { that's it });
              end;
          end
        else with paged_schema_of_this_page do
          begin
            drawing_type := enter_numbered_id(
              extension_being_compiled,
              schema_of_drawing_being_compiled.id_dictionary);
            version := version_being_compiled;
            page := page_being_compiled;
            expandable_ids := NIL;  local_text_macros := NIL;
            old_schema_page := 
	      enter_schema_page(schema_of_drawing_being_compiled,
	                        paged_schema_of_this_page,
	                        old_schema_page_parent,
				is_new_page);

            { Check local text macro definitions -- mark dirty any pages
	      which contain errors from last compilation. }

            if make_pass = MAKE_PASS_1 then
	      compute_current_local_TM_context(old_schema_page, FALSE);
          end;
      end
    else 
      begin
        page_being_compiled := er_page(module_being_compiled);
        clear_errors;
        if (page_being_compiled <> 0) then
          begin
            { get corresponding schema page and delete schema pages that
              no longer exist. }
  
            paged_schema_of_this_page.page := page_being_compiled;
            old_schema_page_parent := old_schema_page;
            old_schema_page := old_schema_page_parent^.next;  done := FALSE;

            while (old_schema_page <> NIL) and not done do
              case compare_paged_schemas(old_schema_page^,
                                         paged_schema_of_this_page) of
                EQ: done := TRUE;
                LT:
                  begin
                    release_paged_schema(old_schema_page_parent^.next);
                    old_schema_page := old_schema_page_parent^.next;
                  end;
                GT:
                  begin
                    old_schema_page := 
                      insert_schema_page(paged_schema_of_this_page,
		                         old_schema_page_parent^.next);
                    done := TRUE;
                  end;
              end;
            if not done then
	      begin
	        old_schema_page :=
                  insert_schema_page(paged_schema_of_this_page,
	                             old_schema_page_parent^.next);
              end;
	      
          end;
      end;

    if page_being_compiled <> 0 then
      begin
	context_description := context_string(specified_context);
        release_string(page_expansion_file_name);
	copy_string(er_filename(module_being_compiled, ord(EXPANSION_FILE),
	                        page_being_compiled, context_description),
		    page_expansion_file_name);

        if page_expansion_file_name = nullstring then make_it := FALSE
        else if (extension_being_compiled = null_name) then
	  make_it := (make_pass = MAKE_PASS_2)
        else
          make_it := make_current_page;

        if make_it and 
	   (extension_being_compiled <> null_name) then
	  begin
	    expansion_file_open := TRUE;
            if not pipe_rewrite_file(CmpExp_pipe, EXPANSION_PIPE,
	                             page_expansion_file_name) then
              begin
	        expansion_file_open := FALSE;
                error(227 { can't open expansion });
                make_it := FALSE;
              end
            else
              begin
	        init_output_continue;
                pipe_dump_alpha(CmpExp_pipe, 'FILE_TYPE=      ');
	        pipe_dump_alpha(CmpExp_pipe, 'EXPANSION;      ');
	        pipe_dump_CRLF(CmpExp_pipe);
                expansion_compile_time := get_compile_time;
              end;
          end;

        if make_it and
	   (extension_being_compiled <> null_name) then
          begin
            release_string(page_list_file_name);
	    copy_string(er_filename(module_being_compiled, ord(LISTING_FILE),
				    page_being_compiled, context_description),
			page_list_file_name);

            if page_list_file_name <> nullstring then
	      if rewrite_file(CmpLst, page_list_file_name, 
	                      CMPLST_FILE_NAME) then
		PrintCmpLst := TRUE;
          end;

        if (command = SEPLINK_COMMAND) and (make_pass = MAKE_PASS_2) then
	  if (num_errors > 0) or 
	     (num_oversights > 0) or
	     (num_warnings > 0) then 
	    if design_specified_in_command_line then
	      write_bogus_expansion_file(CmpTmp_pipe, UNDEFINED_PAGE_NUMBER)
	    else
	      write_bogus_expansion_file(Design_pipe, UNDEFINED_PAGE_NUMBER);

        if make_it then 
          begin
	    clear_errors;
            re_init_expansion_structures;
            init_context(specified_context);
          end
        else
          begin
            if (command = SEPLINK_COMMAND) and (make_pass = MAKE_PASS_2) then
              if (errors_encountered * fatal_errors = []) then
		write_design_file_page_spec;  
            clear_errors;
          end;
      end;
  until make_it or (page_being_compiled = 0);
  init_next_page := make_it;
  if debug_20 then writeln(outfile, 'exit init_next_page ', make_it);
end { init_next_page } ;

