function context_string(context: property_ptr): xtring;
  { build the string that describes the context }
  var
    temp: xtring;              { for construction }
    string_overflow: boolean;
begin { build_local_filename_extension }
  create_a_string(temp, MAX_STRING_LENGTH);
  temp^[0] := chr(0);
  string_overflow := FALSE;

  if context <> NIL then with context^ do
    if name = SIZE_prop_name then
      begin
	if add_string_to_string(temp, text) then ;
	context := next;
      end;

  while (context <> NIL) and not string_overflow do
    with context^ do
      begin
	if add_alpha_to_string(temp, name^.name) then ;
	if not add_quoted_string_to_string(temp, text) then
	  string_overflow := TRUE;
	context := next;
      end;

  if string_overflow then
    begin
      assert(235 { string length exceeded internally });
      write(CmpLog, ' string = ');
      writestring(CmpLog, temp);
      writeln(CmpLog);
      writeln(CmpLog, ' Too many parameters on this drawing');
      if debugging then
	begin
	  write(Outfile, ' string = ');
	  writestring(Outfile, temp);
	  writeln(Outfile);
	  writeln(Outfile, ' Too many parameters on this drawing');
	end;
    end;
  context_string := enter_string(temp);
  temp^[0] := chr(MAX_STRING_LENGTH);
  release_string(temp);
end; { context_string }
      

