 (**)

function is_base_bit(sig_def: signal_definition_ptr; bit: bit_range): boolean;
  { returns TRUE if the given bit of the sig_def is a base bit.  A bit is
    base if it does not appear in the basescript.  If bit = -1, then the
    signal is a scalar. }
var
  found,                        { TRUE if the bit is found in basescript }
  too_far: boolean;             { TRUE if traversed too far in basescript }
  synonym: basescript_ptr;      { current synonym basescript }
  left, right: bit_range;       { bit subscript of the synonym basescript }
begin
  synonym := sig_def^.synonym_bits;

  found := FALSE;  too_far := FALSE;
  while (synonym <> NIL) and not (found or too_far) do
    begin
      left := synonym^.left_index;
      right := synonym^.right_index;

      if bit = -1 then
        found := TRUE   { any basescript is for the entire scalar }
      else
        if left >= right then
          begin
            if (bit <= left) and (bit >= right) then found := TRUE
          end
        else
          if (bit >= left) and (bit <= right) then found := TRUE;

      if not found then synonym := synonym^.next;
    end;

 is_base_bit := NOT found;

 if debug_7 then
   begin
     writeln(outfile, 'Exiting is_base_bit(b=', bit:1, ')=', not found);
     write(outfile, ' basescript: ');
     dump_basescript(outfile, sig_def^.synonym_bits);
   end;
end { is_base_bit } ;


function get_next_base_bit(SI: signal_instance_ptr;
                          bit: bit_range;
                  var next_SI: signal_instance_ptr;
              var next_offset: bit_range): boolean;
{ returns TRUE if we were called with a base bit, otherwise returns
  FALSE and the next baser bit of SI<bit>.

  !!!! Note: synonym_statistics has a routine, chain_length based on this 
       code so if you find any bugs here be sure to update chain_length !!!! 

  NOTE: basescript lists have been found where the indices were not in
  the correct order.  This routine has been patched so that it checks all
  elements of the basecript list.  When (or IF)  other code is fixed so that
  basescript lists are ALWAYS ordered, then this routine can be unpatched
  to take advantage of that.  }
var
  found,              
  too_far: boolean;
  head_basescript: basescript_ptr;

  (* THIS IS PART OF THE WRONG ORDER PATCH -- remove this variable 
     if and when that PATCH is removed *)
  left_to_right: boolean; { set for each element, rather than global }
  (* end of declaration part of this band-aid *)

begin
  if debug_19 then
    begin
      writeln(outfile, ' Entered get_next_base_bit with:');
      dump_signal_instance(outfile, SI);
      writeln(outfile, ' bit: ', bit:1)
    end;


  head_basescript := SI^.defined_by^.synonym_bits;

  next_SI := SI;     next_offset := 0;
  if head_basescript = NIL then found := FALSE
  else
    begin
      found := FALSE; too_far := FALSE;
      while (head_basescript <> NIL) AND (NOT found) AND (NOT too_far) do

        begin
(* THIS IS THE PATCH TO HANDLE WRONGLY ORDERED INDICES and LISTS *)
(* (remove this code) *)(*
          if (left_to_right AND
             (bit < head_basescript^.left_index))
                    OR
             ((NOT left_to_right) AND
           (bit > head_basescript^.left_index)) then too_far := TRUE
*)(* add this code *)
          left_to_right := (head_basescript^.left_index < 
            head_basescript^.right_index);
          if FALSE then { take the place of the removed conditional }
(* end of patch *)

          else
            if(left_to_right AND
            (bit >= head_basescript^.left_index) AND
            (bit <= head_basescript^.right_index))
                    OR
            ((NOT left_to_right) AND
            (bit <= head_basescript^.left_index) AND
            (bit >= head_basescript^.right_index)) then found := TRUE
          else
            head_basescript := head_basescript^.next;
        end;
      if found then
        with head_basescript^ do
          begin
            next_SI     := instance;
            next_offset := offset + ABS(left_index - bit);
          end;
    end;
   
  get_next_base_bit := NOT found;

  if debug_19 then
    begin
      writeln(outfile, ' Exited get_next_base_bit (', NOT found:5,') with:');
      dump_signal_instance(outfile, next_SI);
      writeln(outfile, ' offset: ', next_offset:1)
    end;

end { get_next_base_bit } ;

(**)

function find_base_of_base_descriptor(BD: base_descriptor_ptr;
                             var base_BD: base_descriptor_ptr): boolean;
{ Given a base_descriptor, returns a base descriptor to the most
  base SI that for those bits. This routine only does this if the
  resulting virtual SI is a scalar or single-bit sub range. If the
  base description of BD is more complicated, then NIL is returned.
  find_base_of_base_descriptor is TRUE only if it found the base_BD for BD.
  NOTE: It is assumed that base_BD points to an existing base descriptor.  }

var
  cant_resolve,                 { TRUE iff couldnt find base for BD }
  found_bit,                    { TRUE iff bit refered to by BD occurs
                                  in its virtual instance }
  done: boolean;                { TRUE when base bit has been found (or
                                  assertion failure has occured) }
  offset_to_next_bit,           { offset to next most base bit  }
  bit_of_interest: bit_range;   { pertinent bit of base_BD^.instance }
  next_SI: signal_instance_ptr; { next (more base) SI in the synonym chain   }
begin
  if debug_2 then
    begin
      writeln(outfile, 'Entered find_base_of_base_descriptor: ');
      write(outfile,'  BD: ');
      dump_base_descriptor(outfile, BD);
      write(outfile,'  base_BD: ');
      dump_base_descriptor(outfile, base_BD);
    end;


  if not (BD^.width = 1) then cant_resolve := TRUE
  else
    begin
      if base_BD = NIL then
        begin
          assert(102 { must be called with base_BD pointing to something});
          cant_resolve := TRUE;
        end
      else
        begin
	  base_BD^ := BD^;
	  cant_resolve := FALSE;
	end;

      done := cant_resolve;
      while not done do
        begin
          { if THE bit of BDs signal instance is not base then
            set base_BD to the more base signal of that bit }
          with base_BD^ do
            case instance^.defined_by^.kind of
              SINGLE: begin bit_of_interest := 1; found_bit := TRUE; end;
              VECTOR:
                begin
                  bit_of_interest := 1 + offset; { ordinal }
                  found_bit := nth_bit_of_signal_instance(bit_of_interest,
                                                          instance);
                  { bit of interest is now cardinal }
                  if NOT found_bit then
                    begin
                      assert(103 { bit must occur on base_BD });
                      write(CmpLog,'        BD: ');
                      dump_base_descriptor(CmpLog, BD);
                      write(CmpLog,'   base_BD: ');
                      dump_base_descriptor(CmpLog, base_BD);
                      dump_tree_information(CmpLog, debug_dump_synonyms);
                      cant_resolve := TRUE;  done := TRUE;
                    end;
                end;
              UNDEFINED: 
                begin
                  assert(104 { bit must occur on base_BD });
                  found_bit := FALSE;
                  cant_resolve := TRUE;  done := TRUE;
                end;
            end;
       
          if found_bit then
            begin
              { find next more base SI (and right bit) return TRUE if was
                already base }

              done :=  get_next_base_bit(base_BD^.instance,
                                               bit_of_interest,
                                               next_SI, offset_to_next_bit);
              if NOT done then
                begin
                  base_BD^.instance := next_SI;
                  base_BD^.offset := offset_to_next_bit;
                end;
            end;
        end;
    end;
    
  find_base_of_base_descriptor := NOT cant_resolve;

  if debug_2 or debug_6 then
    begin
      write(outfile, 'Exited find_base_of_base_descriptor (',
                     (NOT cant_resolve), ')');
      if cant_resolve then writeln(outfile, '.')
      else
        begin
          writeln(outfile, ':');
          write(outfile, '  BD: ');
          dump_base_descriptor(outfile, BD);
          write(outfile,'  base_BD: ');
          dump_base_descriptor(outfile, base_BD);
        end;
    end;
end { find_base_of_base_descriptor };

