\" This is the template for the release documentation
\"
\" You need to fill in the following 4 lines with your
\" package name, version string, number of blocks, and
\" Installation format (generally Vinstall or VMSinstall).
\" Then fill in the necessary paragraphs.

.ds PN ValidCOMPILER
.ds VR 1.3 PC-B7
.ds BL 4200
.ds IF Vinstall

.ds CF \*(PN   Version \*(VR
.sp 20
.TL
Release Notice
.sp 12
.LG
.LG
\*(PN
.SM
.SM
.sp 3
Version \*(VR
.sp 3
\*(BL Blocks
.sp 4
\*(IF Installation Format
.sp 15
.AU
.LG
Valid Logic Systems Incorporated
.SM
.AE
.bp
.nr PS 12
.nr VS 14
.NH 1
Introduction
.LP

The \fBValidCOMPILER\fP converts a design, which may be hierarchical,
into a flat netlist usable by verification tools.  It detects and reports
errors in the use of the \fBSCALD III\fP schematic language.
.NH 1
Changes in Version \*(VR
.LP
This release is essentially the same as 1.3\ PC-B6, except that
some internal changes have been made to permit it to run on the new 3.0
operating system featuring NFS.  This code can not be run on earlier
operating systems.
.NH 1
Dependencies
.LP

Library installation resulting in the existence of the files
/u0/scald/config.dat and /u0/lib/master.lib.
\fBGed\fP installation -- \fBged\fP drawings are the \fBValidCOMPILER\fP's
primary input.
.NH 1
Known Problems in Version \*(VR
.LP
.IP *
When SCALD directories are moved and have had shadow directories created
by the system, then the system will create new shadow directories for
the "new" SCALD directory without deleting the one created for the old
one.
.IP *
The linker will not report signals synonymed to their own complement.
The SCALD compiler reports these as ERRORs and the ValidCOMPILER should
do likewise.
.IP *
Errors in processing compiler directives and the "path name exceeds 
maximum length"
error (when generated by the linker)
are generated when no list file is open and thus do not make it into the
cmplst.dat file.  Directives errors are reported to the monitor and to
cmplog.dat.  The "path name exceeds maximum length" error when generated by 
the linker is reported only to the monitor and does not stop the host
tool (ValidCOMPILER, ValidSIM, etc.) from proceeding, 
though its results will be erroneous.  This occurs
because the error is detected while the design is being communicated to
the host tool (other errors being detected before this phase).
Note that this error
occurs \fBvery\fP rarely -- only in cases of very deep hierarchy.
.IP *
The compiler does not detect changes to property attributes 
(such as making a property INHERIT(PIN) where before it was not) when
deciding whether to recompile a page.  
(Property attributes describe how a property can be used, not what
its value is -- see the ValidCOMPILER manual for a full description.)
This kind of change is usually
made very infrequently.
If changes of this kind are made, then
all old page compiler results must be removed by deleting the shadow 
directories that have been used to hold them.
(If shadow directories have not been explicitly specified, then
"rm -r xshadowx" will work just fine when exectued from the directories
in which compilation has been done.)
.IP *
If the REPORT PATH_NAMES, or REPORT ALL directive is specified, the
page compiler will list the drawings in each page in a way that is not
very useful.
.IP *
File locking has not been implemented on the PC version.  This can cause
collision problems if shadow directories are shared between users.  If
this occurs it will usually
show up as assertion check violations issued by the
compiler or linker pointing to some file within the shadow directories.
Deleting this file will clean things up (and will cause the affected
page or drawing to be recompiled on the next run).

.NH 1
Installation and Configuration
.LP
Use vinstall.
.NH 1
Documentation
.LP
Please refer to the ValidCOMPILER Manual and the SCALD III Language manual.

.NH 1
Application Notes
.LP
The 1.2 and 1.1.6 ValidCOMPILERs stored incremental results drawing
directories.  This required that the user of drawings be able to write
to the drawing directories containing them regardless of whether or not
he owned the drawings.  (Library drawings were handled specially by having
the compiler changes its "identify" to lib when compiling drawings owned by
lib.)

The 1.3 ValidCOMPILER does not do this -- it stores its intermediate results
under seperate directories called "shadow" directories.  These are associated
with the SCALD directories from which drawings are used, but are under the
control of the user of the drawings rather than the owner of the drawings.
In this way, the owner can restrict to his drawings, providing only read
access to others without interferring with their ability to use the
drawings in a meaningful way.

If you have drawings that were used by a pre-1.3 ValidCOMPILER, then
it is possible that old obsolete incremental results files exist in
their drawing directories.  A utility has been provided to clean them
up.  This can be run by invoking 
.LP
.RS
.B /u0/scald/compiler/clean 
.I arguments
.RE
.LP
where 'arguments' is replaced by one or more SCALD directory and/or master
library names.  
All incremental results files created by the pre-1.3 
compilers will be removed from the drawing directories listed therein.
This utility has intentionally been left out of the 'bin' directory, as
once it has been used on all of your old SCALD directories, you can forget
it -- it's no longer needed.
.ps
