(**) 
{----------------- Get command line arguments ---------------------------}
{ These interfaces provide  UNIX like access to command line arguments.
  The idea is to map whatever command line argument access exists on 
  the host to this format.

  sargc returns the number of command line arguments (including 1 for
  the program name).

  sargv(n,str) returns the nth argument as a xtring which has been
  entered into the string hash table.

  sargv(0,str) returns the program name. (but see NOTE)
  sargv(1,str) returns the first argument following the program name,
  etc.  
  (The above is the UNIX convention - not the SVS convention)
  sargv returns nullstring if n >= sargc.  

  NOTE: The program name return is actually only implemented for
  the SVS PASCAL (UNIX) version.  On the 370 and VAX versions
  sargv(0,str) returns nullstring (although it is still counted
  in arriving at the value of sargc.)

  init_cli_arg_structures exists to initialize the global scratch
  structures used by these routines.                                    }
{-----------------------------------------------------------------------}


function sargc : integer;
  { return command argument count (including 0th argument) }
begin
  sargc := 0 ; { default for unimplemented hosts }
#if UNIX
  sargc := argc; 
#else
  sargc := cli_arg_last + 1; 
#endif
end; {sargc}


procedure sargv(which_arg : cli_arg_range; var arg : xtring);
  { sets arg to the indicated argument. }
var 
  i: integer;           { index into SVS argv }
  j,len: string_range;  { length of and index into SVS argv[i]^ }
  temp: xtring;
#if SUN || PMAX
  buf: packed array[1..MAX_STRING_LENGTH] of char;
#endif
  done: boolean;
begin
  if which_arg < sargc then
    begin
#if SVS
      i := which_arg + 1;
      len := min(MAX_STRING_LENGTH, length(argv[i]^));
#endif
#if SUN || PMAX
      argv(which_arg, buf);
      len := MAX_STRING_LENGTH;  done := FALSE;
      while (len > 0) and not done do
        if buf[len] = ' ' then len := len - 1
                          else done := TRUE;
#endif
#if UNIX
      temp := nullstring;
      create_a_string(temp,len);
#endif
#if SVS
      for j := 1 to len do temp^[j] := argv[i]^[j];
#endif
#if SUN || PMAX
      for j := 1 to len do temp^[j] := buf[j];
#endif
#if UNIX
      arg := enter_and_release_string(temp);
#else
      arg := cli_arg_array[which_arg];
#endif
    end
  else arg := nullstring;
end; {sargv}
    

procedure init_cli_arg_structures;
  { initializes the global variables used by sargv and sargc.
    On 370 and VAX, they are initialized to hold the command line
    arguments.  On UNIX and unimplemented machines they are 
    nulled.                                                        }
#if VAX
  type
    string = packed array[1..MAX_STRING_LENGTH] of char;
    
  var
    parmstring: string;      { command line (minus command name) }
    commline: xtring; { command line (minus command name) }
    len: string_range; { length of commline }
    i: string_range; { index into commline }
    retcode: integer;  { return code }

  function LIB$GET_FOREIGN(%STDESCR commline: string):
    integer; EXTERN;


  procedure cli_arg_parse(args: xtring; recognize_quotes: boolean);
    { gets the run string and parses it into arguments.  Spaces
      are delimiters.  Quoted strings are taken as 1 argument
      (without the quotes).  If a quote is not matched then
      the rest of the line is taken as that argument ( with
      trailing blanks removed.)  A quoted string may contain any
      number of the other kind of quote.  ( ' and " are recognized
      as quotes.  If one kind of quote starts an argument then
      the same kind of quote (or end of the xtring) finishes it
      and anything else (including the other kind of quote) is
      included in the argument (with the exception of trailing
      blanks occuring when a quote is not matched).) 

      If recognize_quotes, then quoted strings are parsed, else
      args are delimited by white space. }
    label 
      90;
    const
      QUOTE1 = '''';
      QUOTE2 = '"';
      ORD_TAB_CHAR = 9;
      BLANK = ' ';
    var
      TAB_CHAR: char;               { tab character constant }
      args_length: string_range;    { length of args (to be parsed )}
      i: cli_arg_index;                 (* index into cli_arg_array *)
      in_space: boolean;            (* indicates in white space *)
      in_arg: boolean;              (* indicates in argument *)
      start: string_range;          (* start of current arg *)
      finish: string_range;         (* end of current arg *)
      j: string_range;              (* index into an xtring *)
      len: string_range;            (* length of current arg *)
      temp: xtring;                 (* an intermediate result *)
      quoteset: set of char;        (* quotes currently recognized *)
  begin
    TAB_CHAR := chr(ORD_TAB_CHAR);
    for i := 0 to MAX_CLI_ARG_NUMBER do cli_arg_array[i] := nullstring;
    args_length := ord(args^[0]);
    start := 0;  i := 0;
    while (start < args_length) and (i < MAX_CLI_ARG_NUMBER) do
      begin
	i := i + 1;
	in_space := TRUE;
	if recognize_quotes then quoteset := [QUOTE1,QUOTE2]
	                    else quoteset := [];
	while (start < args_length) and in_space do
	  begin
	    start := start + 1;
	    if not (args^[start] in [BLANK,TAB_CHAR]) then
	      in_space := FALSE;
	  end;
	if in_space then
	  begin
	    { done }
	    cli_arg_last := i - 1;
	    goto 90 { return };
	  end
        else if args^[start] in quoteset then
          begin
            quoteset := [args^[start]];
            finish := start;
            if start < args_length then start := start + 1;
          end
	else
	  begin
	    quoteset := [BLANK,TAB_CHAR]; { Whitespace terminates the arg }
	    finish := start;
	  end;
	in_arg := TRUE;
	while (finish < args_length) and in_arg do
	  begin
	    finish := finish + 1;
	    if args^[finish] in quoteset then
	      in_arg := FALSE;
	  end;
	len := finish - start;
	if in_arg then len := len + 1;
	if len > 0 then  create_a_string(cli_arg_array[i], len);
        for j := 1 to len do 
	  cli_arg_array[i]^[j] := args^[start - 1 + j];
	if in_arg then
	  { get rid of trailing blanks (in case we were looking 
	    for an unmatched quote) }
	  begin
	    j := len;
	    while (j > 0) and (cli_arg_array[i]^[j] in
	      [BLANK,TAB_CHAR]) do j := j - 1;
	    if j = 0 then release_string(cli_arg_array[i])
	    else if j < len then
	      begin
	      create_a_string(temp, j);
	      for j := j downto 1 do temp^[j] := cli_arg_array[i]^[j];
	      release_string(cli_arg_array[i]);
	      cli_arg_array[i] := temp;
	    end;
	  end;
	start := finish;
	cli_arg_array[i] := enter_and_release_string(cli_arg_array[i]);
      end;
    cli_arg_last := i;
  90:
  end { cli_arg_parse };


begin { init_cli_arg_structures }

  commline := nullstring;
  len := 0;                             
  retcode := LIB$GET_FOREIGN(parmstring);
  if odd(retcode) then len := MAX_STRING_LENGTH
    else len := 0; (* error occurred *)       
  create_a_string(commline, len);
  for i := 1 to len do
    commline^[i] := parmstring[i];
  cli_arg_parse(commline, TRUE);
  release_string(commline);
#else
  var
    i: cli_arg_index;
begin
  cli_arg_last := 0;
  for i := 0 to MAX_CLI_ARG_NUMBER do cli_arg_array[i] := nullstring;
#endif VAX
end { init_cli_arg_structures };


