
{---------- execution time calculation ---------------------------------}


  compile_date: time_string;          { current date }
  start_elapsed_time,                 { entire run start elapsed time }
  page_elapsed_time,                  { page compilation start elapsed time }
  last_elapsed_time,                  { previous elpased time value }
  start_CPU_time,                     { entire run start CPU time }
  page_CPU_time,                      { page compilation CPU time }
  last_CPU_time: longint;             { previous CPU time value }

  {------- string variables and string table ---------------}

  free_strings: array [1..33] of freeptr;  { list of free strings (by size) }
  s_length: array [1..33] of 0..256;       { list of possible string lengths }
  free_pointers: freeptr;                  { list of free "freeptr"s }
  nullstring: xtring;                      { a null string constant }

  string_table: hash_string_table_type;    { table of all strings }


  { scratch structures for sargv and sargc }
  cli_arg_last : cli_arg_index;        { last defined argument number }
  cli_arg_array: cli_arg_array_type;   { array of arguments }

  { flag for compiler command line arguments from CMPTMP kludge }
  use_CMPTMP_args: boolean;            { TRUE iff args from CMPTMP file
					 instead of command line }


  { -- error routine constants -- }

  scan_past_errors: error_set;        { error really in last symbol }
  assert_strings: assert_type;        { table of assertion error messages }
  error_strings: error_type;          { table of error messages }


  
  exception_code:
               exception_error_type;  { descriptor of run time exception }

  

  { -- debugging vars -- }

  outfile: textfile;      { output file for debug information }
  debug_at_path,          { TRUE if path match debug enabled }
  undebug_at_path,        { TRUE if path match undebug enabled }
  debug_1,                { width resolving }
  debug_2,                { find_base_of_signal }
  debug_3,                { evaluate_binding }
  debug_4,                { sig }
  debug_5,                { NC remove }
  debug_6,                { synonym processing }
  debug_7,                { property processing }
  debug_8,                { macro and directory tables }
  debug_9,                { synonym file }
  debug_10,               { UNIX file I/O }
  debug_11,               { signal assertion checking }
  debug_12,               { enter_sig + found_sig }
  debug_13,               { PASS1 }
  debug_14,               { INHERIT_PIN properties }
  debug_15,               { virtual signals }
  debug_16,               { basescript processing }
  debug_17,               { expansion file }
  debug_18,               { %text macro processing }
  debug_19,               { nth_bit_subscript + base_bit }
  debug_20,               { global procedure entry/exit trace }
  debug_21,               { command line arguments debug }
  debug_22,               { file open/close }
  debug_23,               { "make" }
  debug_24,               { schema updating }
  debug_25,               { parse stack }
  debug_26,               { communication with et (linker) }
  debug_27,               { basescript fixing and synonym check }
  debug_28,               { AVL maintenance }
  debug_29,               { TEMPORARY -- slave flag for debug_30 }
  debug_30,               { TEMPORARY -- clear_text_actual property disposal }
  debug,                              { parse debugging control }
  debugging: boolean;                 { TRUE if any debug flag is on }
  debug_control_specifier:
                 debug_control_list;  { table of debug control directives }
  path_for_debug: xtring;             { path name to watch for }
  path_for_undebug: xtring;           { path name to watch for }
  debug_flags:
            set of debug_flag_range;  { set of flags to set on path match }
  undebug_flags:
            set of debug_flag_range;  { set of flags to clear on path match }
  dumpsigdeflist_ok,                  { controls execution of dumpsigdeflist }
  dumptree_ok,                        { controls execution of dumptree }
  dumpsignals_ok,                     { controls execution of dumpsignals }
  dump_all_names_ok,                  { controls execution of dump_all_names }
  printmacros_ok,                     { controls execution of printmacros }
  printdirectory_ok: boolean;         { controls execution of printdirectory }
  histograms: set of histogram_types; { set of histograms to print }
  histogram_specifiers:
                     histogram_table; { table of histograms to display }





  { -- "constant" symbol tables -- }

  name_table: name_table_type;             { table of identifier names }

  { -- static information for INSYMBOL -- }

  line_pos: string_range;             { char pos of last char read }
  last_char: char;                    { last char read (for look ahead) }
  last_sym_pos: string_range;         { end of last symbol }
  last_string,                        { last input buffer }
  instring: xtring;                   { text line being parsed from }
  read_state: parse_state;            { controls lookahead & initialization }
  valid_chars: radix_characters;      { sets of valid chars by radix }
  current_file: parse_file_type;      { what is current input file }
  radix_width: digit_width_list;      { width (bits) of digit by radix }
  parse_SCALDconstants: boolean;      { TRUE indicates look for Radix specs,
                                        etc. FALSE indicates parse decimal
					numbers in vanilla fashion. }


  { -- lexical analyzer -- }

  sy: symbols;                        { symbol that was parsed }
  id: identifier;                     { if sy=ident then identifier descrip }
  const_val: longint;                 { if sy=constant then constant value }
  const_width: longint;               { width of the last parsed constant }
  lex_string: xtring;                 { if sy=strings then string value }
  upper_case_strings: boolean;        { upper case all strings }
  input_buffer: xtring;               { string read from the input }
  allowed_key_words: setofsymbols;    { current valid key words }
  input_line_number: natural_number;

  { -- other constants -- }

  lower_case: set_of_char;            { the lower case letters }
  letters: set_of_char;               { the upper case letters }
  digits: set_of_char;                { set of digits }
  alphanumeric: set_of_char;          { letters + digits }
  legal_chars: set_of_char;           { all legal (printing) characters }
  identifier_chars: set_of_char;      { valid characters for an identifier }
  default_attributes: name_type_set;  { default property attributes }
  inheritance_attributes:
                      name_type_set;  { all inheritance attributes }
  signal_inheritance_attributes:
                      name_type_set;  { inheritance attributes for signals }
  permission_attributes:
                      name_type_set;  { all permission attributes }
  parameter_attributes:
                      name_type_set;  { id types that are parameters }


  null_name: name_ptr;               { hash table entries for these names }


  constant_chars: set_of_char;        { those chars in a signal const }
  
  { -- file vars --}

  CmpStan:   inputfile;           { standard input file }
  monitor: text;

  dev_null: xtring;
  file1: xtring;
  file2: xtring;



  detected_differences: boolean;


  { global netlist tables }

  prim_table_1: avl_ptr;  { netlist from file 1 }
  prim_table_2: avl_ptr;  { netlist from file 2 }
  sig_table_1: avl_ptr;   { SIGNALS (with properties) from file 1 }
  sig_table_2: avl_ptr;   { SIGNALS (with properties) from file 1 }


  { free lists }

  free_avls: avl_ptr;
  free_avl_object_lists: avl_object_list_ptr;
  free_properties: property_ptr;


  { special property names }

  REP_prop_name: name_ptr;
  PATH_NAME_prop_name: name_ptr;
  NC_string: xtring;


  { directives }

  check_properties: boolean;
