(**)     { ------- file utilities ------- }


function rewrite_file(*txtfil: textfile; filename: xtring;
                       logical: alpha): boolean*);
  { rewrite a file of the given name.  If filename is non-null
    then it is used, otherwise it is opened as a logical file. Logical
    MUST be non-null, as IBM version uses it even if filename is used. }
  var
    number_of_dots: 0..255;      { number of '.'  in filename }
    code: longint;               { system dependent return code }
    mode: open_mode;             { buffer or no ? }
begin
  if debugging then mode := UNBUF_WRITE  else mode := WRITE_MODE;
  code := 0;
  rewrite_file := TRUE;
  if not vopen(txtfil, logical, filename, mode, code) then
    begin
      error(169 { cannot open this file });
      if filename = nullstring then error_dump_alpha_file_name(logical)
      else error_dump_file_name(filename);
      error_dump_ioresult(to_ioresult(code));
      rewrite_file := FALSE;
    end;

end { rewrite_file } ;


function reset_file(*filename: xtring; which: parse_file_type): boolean*);
  { reset a file of the given name.  If the name is NULL, open nameless.  If
    no file can be opened, return FALSE.  WHICH specifies which logical 
    file is to be opened. }
  var
    code: longint;                      { return code from open - 370 }
    logical: alpha;                     { logical file name for UNIX }


begin { reset_file }
  if current_file <> UNKNOWN_FILE then
    begin
      reset_file := FALSE;
      assert(169 { tried to open two files at once });

      writeln(monitor, ' Current file open = ', ord(current_file));
      writeln(monitor, ' New file to open = ', ord(which)); 
    end
  else if which <> STANDARD_FILE then
    begin
      exception_code := OPEN_CREATE_FAIL;
      assert(170 { attempt to open an unknown file });
    end
  else
    begin
      exception_code := NULL_ERROR_CODE;
      logical := 'CMPSTAN         ';
#if UNIX
      if not creset(CmpStan, logical, filename, BUFSIZ) then 
        exception_code := OPEN_CREATE_FAIL; 
#else
      if not vopen(CmpStan, logical, filename, READ_MODE, code) then
        exception_code := OPEN_CREATE_FAIL;
#endif
      reset_file := (exception_code = NULL_ERROR_CODE);
      if exception_code = NULL_ERROR_CODE then current_file := which;
    end;
end { reset_file } ;


function close_parse_file(*which: parse_file_type): boolean*);
  { close the input file }
  var
    code: integer;       { VAX status value }
begin
  if (which <> current_file) or (which <> STANDARD_FILE) then
    begin
      assert(171 { tried to close wrong file! });
      writeln(monitor, 'Current_file = ', ord(current_file), 
                      ';  File to be closed = ', ord(which));
    close_parse_file := FALSE;
    end
  else
    begin
      exception_code := NULL_ERROR_CODE;

#if UNIX
      cfclose(CmpStan);
#else
      if not vclose(CmpStan) then exception_code := CLOSE_FAIL;
#endif

      if exception_code <> NULL_ERROR_CODE then
        begin
          error(168 { cannot close specified file });
          error_dump_alpha_file_name('CMPSTAN         ');
        end;

      close_parse_file := (exception_code = NULL_ERROR_CODE);

    end;
  current_file := unknown_file;
end { close_parse_file } ;


procedure close_file(*var f: textfile; file_name: alpha*);
  { close the given file }
  var
    code: longint;       { system dependent success code }
begin
  exception_code := NULL_ERROR_CODE;

  if not vclose(f) then exception_code := CLOSE_FAIL;

  if exception_code <> NULL_ERROR_CODE then
    begin
      error(168 { cannot close specified file });
      error_dump_alpha_file_name(file_name);
    end;
end { close_file } ;


