
#include "add/v_add.h"
#include "add/add.h"
#include "add/buffer.h"
#include "add/extern.h"
#include <ctype.h>

#define VMS_SUFFIX ".DAT"
#define VMS_SUFFIX_LEN 4
#define DOT '.'
#define DOLLAR '$'
#define FILETYPE_DELIMITER '_'
#define MAX_TYPE_LENGTH 3

/* output files in drawing directory written by pre 1.3 compiler */

#define OLDSCHEMA "OSCHEMA"
#define OLDLINKLST "OLL"
#define OLDPAGEEXP "OPE"
#define OLDPAGELST "OPL"
#define C1_1_6EXP "C116EXP"
#define C1_1_6LST "C116LST"
#define C1_1_6LLI "C116LLI"
#define str_or_null(s) s ? s: "<NULL>"


static struct buffer buffer={BUF_INIT}; /* For returned strings */
static char vms_suffix[VMS_SUFFIX_LEN+1]={VMS_SUFFIX};

 /* Perform filename -> partial-SCALD-name translation for pre 1.3
 compiler output files.
 */

int
Spre_output_filename_translator(platform, filename, file_type, other)
int platform;
char *filename;
char **file_type, **other;
{
    int switch_case = 0;
    char version_delimiter;
    register char *current, *end, *s, *d;

    *file_type = NULL;  *other = NULL;
    if (!filename) return FALSE;

#ifdef DEBUG
    printf("fname_trans(%d, \"%s\")\n", platform, str_or_null(filename));
#endif DEBUG

    switch (platform) {
        case S_UNIX: 
	     if (!strcmp(filename, "schema")) {
	          *file_type = OLDSCHEMA;
#ifdef DEBUG
    printf("    OK -> %s \"%s\"\n", str_or_null(*file_type), 
		  str_or_null(*other));
#endif DEBUG
	          return TRUE;
              }
	    version_delimiter = DOT;
	    break;
        case S_VMS: 
	     if (!strcmp(filename, "SCHEMA.DAT")) {
	          *file_type = OLDSCHEMA;
	          return TRUE;
             }
	    version_delimiter = DOLLAR;
	    break;
	default: return FALSE;
	}

    bufstart(buffer, current, end);

    /* Check for VMS suffix ".DAT" (if VMS) */


    if (platform == S_VMS) {
        char suffix[VMS_SUFFIX_LEN+1];
#ifdef DEBUG
        printf("    Checking for .DAT\n");
#endif DEBUG
        if ((s = filename + strlen(filename) - VMS_SUFFIX_LEN) < filename)
	    return FALSE;
        for (d = suffix; *s ; s++) *d++ = islower(*s) ? toupper(*s) : *s;
	*d = '\0';
	if (strcmp(suffix, vms_suffix)) return FALSE;
	}

    /* drawing type */

#ifdef DEBUG
    printf("    drawing type\n");
#endif DEBUG

    for (s = filename;
         *s && (*s != FILETYPE_DELIMITER) && (*s != version_delimiter);
	 s++ ) {
        if (!isidchar(*s)) return FALSE;
        buf_append_char(buffer, current, end, islower(*s) ? toupper(*s) : *s);
	}

    if (((current - buffer.buf) > ID_LENGTH) || /* much too long ? */
        (current == buffer.buf)) return FALSE; /* not there ? */

    if (!(*s)) return FALSE;  /* ill formed file name */

    /* file type */

#ifdef DEBUG
    printf("    file type\n");
#endif DEBUG

    {
    char filetype[MAX_TYPE_LENGTH], *ft_end;
    d = filetype;  ft_end = filetype + MAX_TYPE_LENGTH;
    for (s++ ; *s && (*s != version_delimiter) ; s++) {
	if (d == ft_end) return FALSE;
        if ((platform == S_UNIX) && !islower(*s)) return FALSE;
        *d++ = islower(*s) ? toupper(*s) : *s;
	if (!(*s)) return FALSE;
        *d = '\0';
    }
#ifdef DEBUG
    printf("    file extension\n");
    printf("%s \n", str_or_null(filetype));
#endif DEBUG
        if (!strcmp(filetype, "LL")) {
	    *file_type = OLDLINKLST;
        }
        else if (!strcmp(filetype, "PE")) {
	    *file_type = OLDPAGEEXP;
        }
        else if (!strcmp(filetype, "PL")) {
	    *file_type = OLDPAGELST;
	}
	else if (!strcmp(filetype, "EXP")) {
	    *file_type = C1_1_6EXP;
	}
	else if (!strcmp(filetype, "LST")) {
	    *file_type = C1_1_6LST;
	}
	else if (!strcmp(filetype, "LLI")) {
	    *file_type = C1_1_6LLI;
	}
	else return FALSE;
    }
    /* file extension */

#ifdef DEBUG
    printf("    file extension\n");
    printf("%s \n", str_or_null(*file_type));
#endif DEBUG
    if (*s++ != version_delimiter) return FALSE;
    buf_append_char(buffer, current, end, DOT);
    while((isalnum(*s)) || (*s == version_delimiter)) {
	   buf_append_char(buffer, current, end, *s++);
    }
    bufend(buffer, current, end);

#ifdef DEBUG
    printf("    file extension\n");
#endif DEBUG

    if (platform == S_VMS) s += VMS_SUFFIX_LEN;
    *other = buffer.buf;
#ifdef DEBUG
    printf("    OK -> %s \"%s\"\n", str_or_null(*file_type), 
		str_or_null(*other));
#endif DEBUG
    return TRUE;
}


static char *
drawing_file(platform, other, suffix)
int platform;
char *other, *suffix;
{
    register char *current, *end, *p;
    char delimiter;
    bufstart(buffer, current, end);

#ifdef DEBUG
    printf(" in drawing_file \n");
    printf("%s \n", str_or_null(other));
    printf("%s \n", str_or_null(suffix));
#endif DEBUG
    switch (platform) {
        case S_UNIX: delimiter = DOT;  break;
        case S_VMS: delimiter = DOLLAR;  break;
	default: return NULL_STRING;
	}

    for (p = other ; *p && (*p != DOT) ; p++)
        if (!isidchar(*p)) return NULL_STRING;
        else buf_append_char(buffer, current, end, *p);
    if (!(*p++)) return NULL_STRING;

    if (suffix) bufcat(buffer, current, end, suffix);

    buf_append_char(buffer, current, end, delimiter);
    for ( ; *p ; p++) {
        if ((!isalpha(*p)) && (!isdigit(*p)) && (*p != delimiter)) 
	       return NULL_STRING;
        else buf_append_char(buffer, current, end, *p);
    }



#ifdef DEBUG
    printf(" middle of drawing_file \n");
    printf("%s \n", str_or_null(buffer.buf));
    printf("%s \n", str_or_null(vms_suffix));
    printf("%s \n", str_or_null(suffix));
#endif DEBUG
    if (platform == S_VMS) {
        for (p = buffer.buf ; *p ; p++) if (islower(*p)) *p = toupper(*p);
	bufcat(buffer, current, end, vms_suffix);
	}
    else
        for (p = buffer.buf ; *p ; p++) if (isupper(*p)) *p = tolower(*p);

bufend(buffer, current, end);
#ifdef DEBUG
    printf(" end of drawing_file \n");
    printf("%s \n", str_or_null(buffer.buf));
    printf("%s \n", str_or_null(suffix));
#endif DEBUG
    return (buffer.buf);
}


/* Perform partial-SCALD-name -> filename translation for pre 1.3 comp
  output files.*/
char *
Spre_output_files_translator(platform, file_type, other)
int platform;
char *file_type, *other;
{
#ifdef DEBUG
    printf(" in Spre_output_files_translator  \n");
    printf("%s \n", str_or_null(file_type));
    printf("%s \n", str_or_null(other));
#endif DEBUG
    if (!file_type) return NULL_STRING; 
    if (!strcmp(file_type, OLDSCHEMA)) {
       if (platform == S_UNIX) return("schema");
       else if (platform == S_VMS) return("SCHEMA.DAT");
       else return NULL_STRING;
    }
    if (!strcmp(file_type, OLDLINKLST))
        return(drawing_file(platform, other, "_ll"));
    if (!strcmp(file_type, OLDPAGEEXP))
        return(drawing_file(platform, other, "_pe"));
    if (!strcmp(file_type, OLDPAGELST))
        return(drawing_file(platform, other, "_pl")); 
    if (!strcmp(file_type, C1_1_6EXP))
        return(drawing_file(platform, other, "_exp")); 
    if (!strcmp(file_type, C1_1_6LST))
        return(drawing_file(platform, other, "_lst")); 
    if (!strcmp(file_type, C1_1_6LLI))
        return(drawing_file(platform, other, "_lli")); 
    else return NULL_STRING;
	
}

/* Initialize the pre 1.3 compiler output files as special 
 (drawing directory) files.   */

void
Sinit_pre_output_files()
{
    s_decl_rdir(Spre_output_filename_translator);
    s_decl_ddir(OLDSCHEMA, Spre_output_files_translator);
    s_decl_ddir(OLDLINKLST, Spre_output_files_translator);
    s_decl_ddir(OLDPAGEEXP, Spre_output_files_translator);
    s_decl_ddir(OLDPAGELST, Spre_output_files_translator);
    s_decl_ddir(C1_1_6EXP, Spre_output_files_translator);
    s_decl_ddir(C1_1_6LST, Spre_output_files_translator);
    s_decl_ddir(C1_1_6LLI, Spre_output_files_translator);
} 
