#include <stdio.h>
#include "heap.h"
extern int time(int*);

static heap a;
const COUNT = 2048;
const INCREMENT = 1024;

int
toint(char* s)
{
    int i = 0;
    while (*s) i = 10*i + (*s++ - '0');
    return i;
}


main(int argc, char** argv) 
{
    int increment = INCREMENT;
    if (argc > 1) increment = toint(argv[1]);
    int count = COUNT;
    if (argc > 2) count = toint(argv[2]);

    fprintf(stderr, "Allocating %d bytes %d times\n", increment, count);
    void *p;
    for ( ; count ; count--) p = a.mem(increment);

    fprintf(stderr, "Destroying the heap\n");
    int stime = time(0);
    a.pool();
    int etime = time(0);
    fprintf(stderr, "Heap destroyed in about %d seconds\n", etime - stime);
}


