#include "lib/misc/platform.h"
#include "lib/mem/internals.h"
#include "heap.h"

static mainarena _primaryarena;


char* heap::strcpy(const char* s)
{
    check();
    char* d = 0;
    if (s) {
	d = (char*)mem(strlen(s)+1);
	::strcpy(d, s);
    }
    return d;
}


void heap::pool()
{ 
    if (arena) mempool(&arena); 
}


void heap::establish()
{
    if (!arena) {
	if (!marena) marena = &_primaryarena;
	marena->establish();
	memarena(marena->marena, &arena);
    }
}


/* The following macros are stolen from the C code for cmem so that the
   size calculation done therein can be duplicated exactly here. */

#define to_power_of_2_boundary(n, exponent)\
    (((n - 1 + (1 << exponent)) >> exponent) << exponent)
#define to_word_boundary(n) to_power_of_2_boundary(n, LOG2_WORDSIZE)

void *heap::calloc(unsigned count, unsigned size)
{
    size = to_word_boundary(size);
    size = size * count + 4;
    unsigned *p = (unsigned *)::cmem(arena, 1, size);
    *p = size;
    return offset(p, 4);
}

