#ifndef gstack
#include "gring.h"
/*
    gstack.h -- generic stack (LIFO).

    Use -- analagous to the use of the singly linked rings in gring.h,
    but with member function appropriate to stacks.
    See gring.h for a full explanation of how this pattern of declarations
    works.

    Given these definitions:

    gstack_define(next,bar);

    class bar {
        // ...
	gstack_inst(next,bar);
        // ...
    };	

    gstack_inline(next,bar);

    class foo {
        //...
    public:
        // ...
	gstackroot(next,bar) bars;
        // ...
    };	
        
    You get the following member functions for foo->bars:

        void push(bar*);
        bar* pop();
        boolean isempty();

    It is legal to pop() an empty stack -- it will return 0.
*/


#define gstack(member,type) name3(stack_,type,member)
#define gstackroot(member,type) name3(stackroot_,type,member)


#define gstack_inst(member,type)\
    friend gringroot(member,type);  gstack(member,type) member


#define gstack_define(member,type)\
\
gring_define(member,type);\
\
class gstack(member,type) : gring(member,type) {\
    friend class gringroot(member,type);\
public:\
    gstack(member,type)() {};\
};\
\
class gstackroot(member,type) : gringroot(member,type) {\
public:\
    gstackroot(member,type)() {}\
\
    boolean isempty();\
    void push(type* rec);\
    type* pop();\
}


/*
    The following must come after the definition of class "type".
*/
#define gstack_functions(member,type,specifier,gring_funcs)\
\
gring_funcs(member,type);\
\
specifier boolean gstackroot(member,type)::isempty() { return !last(); }\
specifier void gstackroot(member,type)::push(type* rec)\
    { insert_front(rec); }\
specifier type* gstackroot(member,type)::pop()\
    { return isempty() ? 0 : remove_first(); }


#define gstack_inline(member,type) gstack_functions(member,type,inline,gring_inline)
#endif
