#ifndef gqueue
#include "gring.h"
/*
    gqueue.h -- generic queue (FIFO).

    Use -- analagous to the use of the singly linked rings in gring.h,
    but with member function appropriate to queues.
    See gring.h for a full explanation of how this pattern of declarations
    works.

    Given these definitions:

    gqueue_define(next,bar);

    class bar {
        // ...
	gqueue_inst(next,bar);
        // ...
    };	

    gqueue_inline(next,bar);

    class foo {
        //...
    public:
        // ...
	gqueueroot(next,bar) bars;
        // ...
    };	
        

    You get the following member functions for foo->bars:

        void enqueue(bar*);
        bar* dequeue();
        boolean isempty();

    It is legal to dequeue() an empty queue -- it will return 0.
*/


#define gqueue(member,type) name3(queue_,type,member)
#define gqueueroot(member,type) name3(queueroot_,type,member)


#define gqueue_inst(member,type)\
    friend gringroot(member,type);  gqueue(member,type) member


#define gqueue_define(member,type)\
\
gring_define(member,type);\
\
class gqueue(member,type) : gring(member,type) {\
    friend class gringroot(member,type);\
public:\
    gqueue(member,type)() {};\
};\
\
class gqueueroot(member,type) : gringroot(member,type) {\
public:\
    gqueueroot(member,type)() {}\
\
    boolean isempty();\
    void enqueue(type* rec);\
    type* dequeue();\
}


/*
    The following must come after the definition of class "type".
*/
#define gqueue_functions(member,type,specifier,gring_funcs)\
\
gring_funcs(member,type);\
\
specifier boolean gqueueroot(member,type)::isempty() { return !last(); }\
specifier void gqueueroot(member,type)::enqueue(type* rec) { insert_rear(rec); }\
specifier type* gqueueroot(member,type)::dequeue()\
    { return isempty() ? 0 : remove_first(); }


#define gqueue_inline(member,type) gqueue_functions(member,type,inline,gring_inline)
#endif
