#ifndef BH_CHARP_H
#define BH_CHARP_H 1
#include <string.h>


extern int case_insensitive_strcmp(const char*, const char*);


// Useful typedefs for building type-cast operators -- 
// in particular operator const_charP() is very useful

typedef char* insensitive_charP;  // for building case-insensitive tables
typedef char* charP;
typedef const char* const_charP;


// Classes for getting to use the relational operators on char pointers.
// CharP has no constructor on purpose -- so it can be a member of a union.
// ConstCharP has no assignment operator on purpose -- it is meant to be "const".

class CharP {
    char* s;
public:
    char* operator=(char* c) { return s = c; }
    operator char*() { return s; }
};


class ConstCharP {
    char* s;
public:
    ConstCharP(const char* c) { s = (char*)c; }
    operator const_charP() { return s; }
    cmp(const char* o) { return strcmp(s, o); }

    // relops with char*
    operator==(const char* o) { return cmp(o) == 0; }
    operator!=(const char* o) { return cmp(o) != 0; }
    operator<(const char* o) { return cmp(o) < 0; }
    operator<=(const char* o) { return cmp(o) <= 0; }
    operator>(const char* o) { return cmp(o) > 0; }
    operator>=(const char* o) { return cmp(o) >= 0; }
    friend operator==(const char* o, ConstCharP t) { return t.cmp(o) == 0; }
    friend operator!=(const char* o, ConstCharP t) { return t.cmp(o) != 0; }
    friend operator<(const char* o, ConstCharP t) { return t.cmp(o) > 0; }
    friend operator<=(const char* o, ConstCharP t) { return t.cmp(o) >= 0; }
    friend operator>(const char* o, ConstCharP t) { return t.cmp(o) < 0; }
    friend operator>=(const char* o, ConstCharP t) { return t.cmp(o) <= 0; }

    // relops with self need to be disambiguated
    operator==(ConstCharP o) { return cmp(o) == 0; }
    operator!=(ConstCharP o) { return cmp(o) != 0; }
    operator<(ConstCharP o) { return cmp(o) < 0; }
    operator<=(ConstCharP o) { return cmp(o) <= 0; }
    operator>(ConstCharP o) { return cmp(o) > 0; }
    operator>=(ConstCharP o) { return cmp(o) >= 0; }

    // relops with CharP need to be disambiguated
    operator==(CharP o) { return cmp(o) == 0; }
    operator!=(CharP o) { return cmp(o) != 0; }
    operator<(CharP o) { return cmp(o) < 0; }
    operator<=(CharP o) { return cmp(o) <= 0; }
    operator>(CharP o) { return cmp(o) > 0; }
    operator>=(CharP o) { return cmp(o) >= 0; }
    friend operator==(CharP o, ConstCharP t) { return t.cmp(o) == 0; }
    friend operator!=(CharP o, ConstCharP t) { return t.cmp(o) != 0; }
    friend operator<(CharP o, ConstCharP t) { return t.cmp(o) > 0; }
    friend operator<=(CharP o, ConstCharP t) { return t.cmp(o) >= 0; }
    friend operator>(CharP o, ConstCharP t) { return t.cmp(o) < 0; }
    friend operator>=(CharP o, ConstCharP t) { return t.cmp(o) <= 0; }

};


#endif
