#include <string.h>
#include "RingBuffer.h"
#define THIS RingBuffer
THIS glob_ringbuffer;


char* THIS::strcpy(const char* s)
{
    if (!s) return 0;
    char* v = (*this)(strlen(s)+1);
    ::strcpy(v, s);
    return v;
}


THIS::~THIS()
{
    if (!h) delete[buf_size] buf;
    else {
	h->memfree(buf, buf_size);
	if (allocated) {
	    h->memfree(this, sizeof(THIS));
	    this = 0;
	}
    }
}


THIS::THIS(unsigned size) 
{
    h = 0;  allocated = FALSE;
    buf_size = size;
    buf = new char[buf_size];
    pos = buf;
}


THIS::THIS(heap& _h, unsigned size) 
{
    boolean alloc = !this;
    this = this ? this : (THIS*)_h.mem(sizeof(THIS));
    h = &_h;

    allocated = alloc;
    buf_size = size;

    if (!h) buf = new char[buf_size];
    else buf = (char*)h->mem(buf_size);

    pos = buf;
}


char* THIS::operator()(unsigned size)
{
    if (size > buf_size) {
	if (!h) {
	    delete[buf_size] buf;
	    buf = new char[size];
	}
	else {
	    h->memfree(buf, buf_size);
	    buf = (char*)h->mem(size);
	}
	buf_size = size;
	pos = buf;
    }
    
    if (pos + size > buf + buf_size) pos = buf;
    char* val = pos;
    pos += size;
    return val;
}

