/* Stack.c -- implementation of class Stack

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	October, 1985

Function:
	
Member function definitions for class Stack.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

7-Jan-86	K. E. Gorlen

1.  Add Stack::species().

2.  Modify Stack::isEqual to use species().

*/

#include "Stack.hxx"
#include "oopsIO.hxx"

#define	THIS	Stack
#define	BASE	SeqCltn
DEFINE_CLASS(Stack,SeqCltn,1,NULL,NULL);

obid Stack::add(const Object& ob)	{ return contents.add(ob); }

Collection& Stack::addContentsTo(Collection& cltn)
{
	return contents.addContentsTo(cltn);
}

obid& Stack::at(int i)		{ return contents.at(size()-i-1); }

UNSIGNED Stack::capacity()	{ return contents.capacity(); }

void Stack::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	contents.deepenShallowCopy();
}

UNSIGNED Stack::hash()		{ return contents.hash(); }

bool Stack::isEmpty()		{ return contents.size()==0; }

bool Stack::isEqual(const Object& ob)
{
	return ob.isSpecies(class_Stack) && contents.isEqual(((Stack*)&ob)->contents);
}

const Class* Stack::species()	{ return &class_Stack; }

obid Stack::last()		{ return contents.last(); }

void Stack::printOn(ostream& strm)
{
	strm << className() << "[";
	for (register UNSIGNED i=size(); i>0; i--) {
		if(i<size()) strm << "\n";
		contents.at(i-1)->printOn(strm);
	}
	strm << "]\n";
}

void Stack::reSize(UNSIGNED newSize) { contents.reSize(newSize); }

obid Stack::removeLast()	{ return contents.removeLast(); }

UNSIGNED Stack::size()		{ return contents.size(); }

static UNSIGNED stack_capacity;

Stack::Stack(istream& strm, Stack& where) : contents((strm >> stack_capacity, stack_capacity))
{
	this = &where;
	UNSIGNED n;
	strm >> n;		// read Stack size 
	while (n--) add(*readFrom(strm));
}

void Stack::storer(ostream& strm)
{
	Object::storer(strm);
	strm << contents.capacity() << " " << contents.size();
	DO(contents,obid,ob) ob->storeOn(strm); OD
}

Stack::Stack(fileDescTy& fd, Stack& where) : contents((readBin(fd,stack_capacity), stack_capacity))
{
	this = &where;
	UNSIGNED n;
	readBin(fd,n);
	while (n--) add(*readFrom(fd));
}

void Stack::storer(fileDescTy& fd) 
{
	Object::storer(fd);
	storeBin(fd,contents.capacity());
	storeBin(fd,contents.size());
	DO(contents,obid,ob) ob->storeOn(fd); OD
}
