#ifndef REGEXPH
#define REGEXPH
/*
 *  REGEXP - expand a regular expression into matching file names.
 *         (shell regular expressions)
 *  
 *  example of usage:
 *
 *  REGEXP REGEXP("*");
 *  StringOC matchingNames(*REGEXP.Expand());
 *  DO(matchingNames,PString,nm)
 *      cout << nm << "\n";
 *  OD
 */

class RegExp : public Object {
    String PATTERN;
public:
    RegExp() : PATTERN("") {};
    RegExp(const String& pat) : PATTERN(pat) {};
    RegExp(const RegExp&);
    RegExp(fileDescTy&, RegExp&);
    RegExp(istream&, RegExp&);
    virtual const Class* isA();
    void operator=(const RegExp&);
    bool operator==(const RegExp&);
    void storer(ostream &strm);
    void storer(fileDescTy &fd);
    virtual UNSIGNED hash();
    virtual bool isEqual(const Object&);
    virtual void deepenShallowCopy();

    virtual void Pattern(const String& regexp) { PATTERN = regexp; }
    virtual const String& 	Pattern() {return PATTERN;}

    virtual bool Match(const String& word);

};

#endif

