/* LookupKey.c -- implementation of Dictionary LookupKey

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:
	
LookupKey is an abstract class for managing the key object of an Assoc.
It is used to implement class Dictionary.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

1-Oct-86	K. E. Gorlen

1. C++ Release 1.1: restore use of default argument in constructor.

30-Apr-86	K. E. Gorlen

1. Remove call to BASE:deepenShallowCopy() from deepenShallowCopy().

17-Apr-86	K. E. Gorlen

1.  Eliminate use of "," operator from _reader function.

*/

#include "LookupKey.hxx"

#define	THIS	LookupKey
#define	BASE	Object
DEFINE_CLASS(LookupKey,Object,1,NULL,NULL);

LookupKey::LookupKey(const Object& newKey)
{
	akey = &newKey;
}

obid LookupKey::key()	{ return akey; }

obid LookupKey::key(const Object& newkey)
{
	obid temp = akey;
	akey = &newkey;
	return temp;
}

bool LookupKey::isEqual(const Object& ob) { return ob.isEqual(*akey); }

UNSIGNED LookupKey::hash() { return akey->hash(); }

int LookupKey::compare(const Object& ob) { return ob.compare(*akey); }

void LookupKey::deepenShallowCopy()
{
	akey = akey->deepCopy();
}

void LookupKey::printOn(ostream& strm)
{
	akey->printOn(strm);
}

obid LookupKey::value()
{
	derivedClassResponsibility("value"); return (obid)0;
}

obid LookupKey::value(const Object& newvalue)
{
	derivedClassResponsibility("value"); return (obid)&newvalue;
}

LookupKey::LookupKey(istream& strm, LookupKey& /*where*/)
{
	akey = readFrom(strm);
}

void LookupKey::storer(ostream& strm)
{
	BASE::storer(strm);
	akey->storeOn(strm);
}

LookupKey::LookupKey(fileDescTy& fd, LookupKey& /*where*/)
{
	akey = readFrom(fd);
}

void LookupKey::storer(fileDescTy& fd) 
{
	BASE::storer(fd);
	akey->storeOn(fd);
}
