/* Linkobid.c -- implementation of singly-linked list Object pointer element

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	October, 1985

Function:

Objects of class Linkobid are used to link Objects into a LinkedList.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

1-Oct-86	K. E. Gorlen

1. C++ Release 1.1: restore use of default argument in constructor.

*/

#include "Linkobid.hxx"
#include "oopsIO.hxx"

#define	THIS	Linkobid
#define	BASE	Link
DEFINE_CLASS(Linkobid,Link,1,NULL,NULL);

Linkobid::Linkobid(const Object& newval)
{
	val = &newval;
}

UNSIGNED Linkobid::capacity()		{ return val->capacity(); }

int Linkobid::compare(const Object& ob)	{ return ob.compare(*val); }

void Linkobid::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	val = val->deepCopy();
}

UNSIGNED Linkobid::hash()			{ return val->hash(); }

bool Linkobid::isEqual(const Object& ob)	{ return ob.isEqual(*val); }

void Linkobid::printOn(ostream& strm)
{
	strm << className() << "("; val->printOn(strm); strm << ")";
}

UNSIGNED Linkobid::size()			{ return val->size(); }

obid Linkobid::value()	{ return val; }

obid Linkobid::value(const Object& newval)
{
	obid temp = val;
	val = &newval;
	return temp;
}

Linkobid::Linkobid(istream& strm, Linkobid& where)
{
	this = &where;
	val = readFrom(strm);
}

void Linkobid::storer(ostream& strm)
{
	BASE::storer(strm);
	val->storeOn(strm);
}

Linkobid::Linkobid(fileDescTy& fd, Linkobid& where)
{
	this = &where;
	val = readFrom(fd);
}

void Linkobid::storer(fileDescTy& fd) 
{
	BASE::storer(fd);
	val->storeOn(fd);
}
