#ifndef LINKH
#define LINKH 

/* Link.hxx -- declarations for singly-linked list element

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"

extern Class class_Link;

class LinkedList;

class Link: public Object {
	Link* next;		// pointer to next Link or nil 
	friend LinkedList;
public:
	Link(const Link& nextlink)	{ next = &nextlink; }
	Link()				{ next = (Link*)nil; }
	Link(fileDescTy&,Link&) {}
	Link(istream&,Link&) {}
	~Link();
	Link* nextLink()		{ return next; }
	Link* nextLink(const Link* nextlink)	{ next = nextlink; return next; }
	virtual void deepenShallowCopy();
	virtual const Class* isA();
	virtual obid shallowCopy();		// shouldNotImplement
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
