#ifndef DICTIONARYH
#define DICTIONARYH 

/* Dictionary.hxx -- declarations for Set of Associations

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Set.hxx"

extern Class class_Dictionary;

class LookupKey;
class Assoc;
class OrderedCltn;

class Dictionary: public Set {
public:
	Dictionary(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	Dictionary(const Dictionary&);
	Dictionary(fileDescTy&,Dictionary&);
	Dictionary(istream&,Dictionary&);
	void operator=(const Dictionary&);
	bool operator==(const Dictionary&);
	bool operator!=(const Dictionary& d)	{ return !(*this == d); }
	virtual	obid add(const Object&);
	virtual Assoc* addAssoc(const Object& key, const Object& value);
	virtual Collection& addContentsTo(Collection&);
	virtual Collection& addKeysTo(Collection&);
	virtual Collection& addValuesTo(Collection&);
	virtual LookupKey& assocAt(const Object& key);
	virtual obid atKey(const Object& key);
	virtual obid atKey(const Object& key, const Object& newValue);
	virtual bool includesAssoc(const LookupKey& asc);
	virtual bool includesKey(const Object& key);
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual obid keyAtValue(const Object& val);
	virtual UNSIGNED occurrencesOf(const Object& val);
	virtual obid remove(const Object& asc);
	virtual LookupKey& removeAssoc(const LookupKey& asc);
	virtual LookupKey& removeKey(const Object& key);
	virtual const Class* species();
};

#endif
