/* Collection.c -- implementation of abstract Collection class

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985


Function:
	
Collection is an abstract class that actually implements only the
addAll, removeAll, includes, isEmpty, and Collection.conversion
functions.  Note that the functions Collection::asBag, asOrderedCltn,
asSet, and asSortedCltn are defined in the file that implements the
respective target Collection so that all of these classes are not loaded
whenever any one Collection is used.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

29-Apr-86	K. E. Gorlen

1. Eliminate implementation of Collection::copy().
2. Implement deepenShallowCopy() as {}.
3. Implement shallowCopy as shouldNotImplement().

17-Apr-86	K. E. Gorlen

1.  Eliminate use of "," operator from _reader function.

5-Mar-86	K. E. Gorlen

1.  Redefine copy() as deepCopy().

9-Jan-86	K. E. Gorlen

1.  Modify Collection::storer to write out collection capacity.

25-May-89	R. Edwards (Valid Logic)

1. Added CollectionEnu class for enumeration and added funtion newEnu()
   to Collection to return an initialized enumerator

*/

#include "Collection.hxx"
#include "Arrayobid.hxx"
#include "oopsIO.hxx"

#define	THIS	Collection
#define	BASE	Object
DEFINE_CLASS(Collection,Object,1,NULL,NULL);
DEFINE_CLASS(CollectionEnu,Object,1,NULL,NULL);

obid Collection::add(const Object& ob) { derivedClassResponsibility("add"); return &ob; }

const Collection& Collection::addAll(const Collection& c)
{
	c.addContentsTo(*this);
	return c;
}

Collection& Collection::addContentsTo(Collection& ob) { derivedClassResponsibility("addContentsTo"); return ob; }

obid Collection::remove(const Object& ob) { derivedClassResponsibility("remove"); return &ob; }

const Collection& Collection::removeAll(const Collection& c)
{
	DO(c,obid,o) remove(*o); OD
	return c;
}

void Collection::deepenShallowCopy() {}

bool Collection::includes(const Object& ob) { return occurrencesOf(ob) != 0; }

bool Collection::isEmpty() { return size() == 0; }

UNSIGNED Collection::occurrencesOf(const Object&) { derivedClassResponsibility("occurrencesOf"); return 0; }

Arrayobid Collection::asArrayobid()
{
	Arrayobid a(size());
	register obid* q = &(a.elem(0));
	DO(*this,obid,o) *q++ = o; OD
	return a;
}
 
obid Collection::doNext(DoCltnPos& /*pos*/)
	{ derivedClassResponsibility("doNext"); return 0; }

obid Collection::shallowCopy()	{ shouldNotImplement("shallowCopy"); return 0; }
	
UNSIGNED Collection::size() { derivedClassResponsibility("size"); return 0; }

void Collection::storer(ostream& strm)
{
	BASE::storer(strm);
	strm << capacity() << " " << size();
	DO(*this,obid,ob) ob->storeOn(strm); OD
}

void Collection::storer(fileDescTy& fd) 
{
	BASE::storer(fd);
	storeBin(fd,capacity());
	storeBin(fd,size());
	DO(*this,obid,ob) ob->storeOn(fd); OD
}

CollectionEnu*
Collection::newEnu() {
    return new CollectionEnu(this);
}
