#ifndef	BITSETH
#define	BITSETH

/* BitSet.hxx -- declarations for set of small integers

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

14-Feb-87	K. E. Gorlen

1.  Correct implementation of Bitset::includes().

*/

#include "Object.hxx"

inline UNSIGNED BIT(UNSIGNED i)	{ return 1<<i; }

extern Class class_Bitset;

class Bitset: public Object {
protected:
	UNSIGNED m;
	Bitset(int i, float dum)	{ (dum, m = i); }
public:
	Bitset()			{ m = 0; }
	Bitset(int i1)			{ m = BIT(i1); }
	Bitset(int i1, int i2)		{ m = BIT(i1)|BIT(i2); }
	Bitset(int i1, int i2, int i3)
		{ m = BIT(i1)|BIT(i2)|BIT(i3); }
	Bitset(int i1, int i2, int i3, int i4)
		{ m = BIT(i1)|BIT(i2)|BIT(i3)|BIT(i4); }
	Bitset(int i1, int i2, int i3, int i4, int i5)
		{ m = BIT(i1)|BIT(i2)|BIT(i3)|BIT(i4)|BIT(i5); }
	Bitset(int i1, int i2, int i3, int i4, int i5, int i6)
		{ m = BIT(i1)|BIT(i2)|BIT(i3)|BIT(i4)|BIT(i5)|BIT(i6); }
	Bitset(int i1, int i2, int i3, int i4, int i5, int i6, int i7)
		{ m = BIT(i1)|BIT(i2)|BIT(i3)|BIT(i4)|BIT(i5)|BIT(i6)|BIT(i7);}
	Bitset(const Bitset& n)		{ m = n.m; }
	Bitset(fileDescTy&,Bitset&);
	Bitset(istream&,Bitset&);
	Bitset operator~()		{ return Bitset(~m, 0.0); }
	Bitset operator-(Bitset n)	{ return Bitset(m & ~n.m, 0.0); }
	bool operator>(Bitset n)	{ return m == (m|n.m) && m != n.m; }
	bool operator<(Bitset n)	{ return n.m == (m|n.m) && m != n.m; }
	bool operator>=(Bitset n)	{ return m == (m|n.m); }
	bool operator<=(Bitset n)	{ return n.m == (m|n.m); }
	bool operator==(Bitset n)	{ return m == n.m; }
	bool operator!=(Bitset n)	{ return m != n.m; }
	Bitset operator&(Bitset n)	{ return Bitset(m & n.m, 0.0); }
	Bitset operator^(Bitset n)	{ return Bitset(m ^ n.m, 0.0); }
	Bitset operator|(Bitset n)	{ return Bitset(m | n.m, 0.0); }
	void operator=(Bitset n)	{ m = n.m; }
 	void operator-=(Bitset n)	{ m &= ~n.m; }
	void operator&=(Bitset n)	{ m &= n.m; }
	void operator^=(Bitset n)	{ m ^= n.m; }
	void operator|=(Bitset n)	{ m |= n.m; }
	int  asMask()			{ return m; }
	void asMask(int msk)		{ m = msk;  }
	bool includes(int i)		{ return (m & BIT(i)) != 0; }
	virtual UNSIGNED capacity();
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED hash();
	virtual const Class*	isA();
	virtual bool	isEmpty();
	virtual bool	isEqual(const Object&);
	virtual void	printOn(ostream&);
	virtual UNSIGNED size();
	virtual const Class*	species();
	virtual void	storer(fileDescTy&);
	virtual void	storer(ostream&);
};

#endif
