#ifndef BAGH
#define BAGH

/* Bag.hxx -- declarations for Set of Objects with possible duplicates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Collection.hxx"
#include "Dictionary.hxx"

extern Class class_Bag;

class Bag: public Collection {
	UNSIGNED count;
	Dictionary contents;
public:
	Bag(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	Bag(const Bag&);
	Bag(fileDescTy&,Bag&);
	Bag(istream&,Bag&);
	obid addWithOccurrences(const Object&, UNSIGNED);
	bool operator!=(const Bag& a)			{ return !(*this==a); }
	void operator=(const Bag&);
	bool operator==(const Bag&);
	virtual	obid	add(const Object&);
	virtual Collection& addContentsTo(Collection&);
	virtual UNSIGNED capacity();
	virtual void	deepenShallowCopy();
	virtual obid	doNext(DoCltnPos&);
	virtual UNSIGNED hash();
	virtual const Class*	isA();
	virtual bool	isEqual(const Object&);
	virtual UNSIGNED occurrencesOf(const Object&);
	virtual void	printOn(ostream& strm);
	virtual void	reSize(UNSIGNED);
	virtual obid	remove(const Object&);
	virtual UNSIGNED size();
	virtual const Class*	species();
	virtual void storer(fileDescTy&);
	virtual void	storer(ostream&);
};

#endif
