/* Array.h.m4 -- template for declarations for generic array objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:

m4 macro template for the .h files for arrays of the specified
fundamental type: char, int, short, long, unsigned, float, and double.
For example, to generate the declarations for an array of chars:

	echo "ARRAYDECLARE(Arraychar,char,friend SubString;)" | m4 Array.h.m4 - >Arraychar.h

Modification History:

25-Feb-87	K. E. Gorlen

1.  Quote preprocessor commands for 4.2BSD m4 compatibility.

29-Oct-86	K. E. Gorlen

1.  Convert to m4 macro template.

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

16-Jul-86	K. E. Gorlen

1.  Use empty comment instead of \n in ARRAY_CLASS macro.

24-Mar-86	S. M. Orlow

1.  Initialized constructors replaced to work around C++ bug.
	
7-Jan-8		K. E. Gorlen

1.  Added classname::species().
*/


#ifndef ArrayintH
#define ArrayintH

#include "Collection.hxx"

extern Class class_Arrayint;

class Arrayint: public Collection {
protected:
	int* v;
	UNSIGNED sz;
	void AllocSizeErr();
	void IndexRangeErr();
// friends go here
	

public:
	Arrayint(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	Arrayint(const Arrayint&);
	~Arrayint()		{ delete v; }
	Arrayint(fileDescTy&,Arrayint&);
	Arrayint(istream&,Arrayint&);
	int& elem(int i)	{ return v[i]; }
	bool operator!=(const Arrayint& a) { return !(*this==a); }
	void operator=(const Arrayint&);
	bool operator==(const Arrayint&);
	int& operator[](int i)
	  { if ((unsigned)i >= sz) IndexRangeErr(); return v[i]; }
	virtual int& at(int i);
	virtual UNSIGNED capacity();
	virtual void deepenShallowCopy();
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void reSize(UNSIGNED);
	virtual UNSIGNED size();
	virtual void sort();
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
	virtual void clearForReadFrom();
};

#endif

