# 1 "Arraychar.cxx" 













































































# 1 "./Arraychar.hxx" 1



























































# 1 "./Collection.hxx" 1



























# 1 "./Object.hxx" 1














































































# 1 "/usr/include/stdio.h" 1





extern	struct	_iobuf {
	int	_cnt;
	unsigned char *_ptr;
	unsigned char *_base;
	int	_bufsiz;
	short	_flag;
	char	_file;		
} _iob[];



















# 36 "/usr/include/stdio.h" 

















extern struct _iobuf	*fopen();
extern struct _iobuf	*fdopen();
extern struct _iobuf	*freopen();
extern struct _iobuf	*popen();
extern struct _iobuf	*tmpfile();
extern long	ftell();
extern char	*fgets();
extern char	*gets();
# 63 "/usr/include/stdio.h" 

extern char	*ctermid();
extern char	*cuserid();
extern char	*tempnam();
extern char	*tmpnam();






# 80 "./Object.hxx" 2
# 1 "./errors.hxx" 1













const int MAX_MSG_ARG =	8;      
const int MAX_FACILITIES = 32;  
const int SYS_LAST_ERROR = 34;	


enum severity_level { SUCCESS = 0,
		      INFORMATION = -1,
		      INFO = -1,
		      WARNING = -2,
		      ERROR = -3,
		      FATAL = -4,
		      DEFAULT = 1 };


const int FAC_SHIFT =    12;	    // right shift count to get facility code
const int OFFSET_MASK =  0xfff;     // mask for offset portion of error 
const int FAC_MASK =     0xfff000;  // mask for facility portion 

inline int FACILITY_CODE(int ER) { return ((ER&FAC_MASK)>>FAC_SHIFT); }
inline int OFFSET_INDEX(int ER)  { return (ER&OFFSET_MASK); }

class ErrSpecs {
public:
	int severity;		
	char* args;		
	char* text;		
	};


class ErrFac {
public:
	char* longname;		
	ErrSpecs* errlist;	
	int last;		
	};

# 82 "./Object.hxx" 2

const char YES = 1;
const char NO = 0;
typedef int fileDescTy;

overload ABS;
inline int	ABS(int x)	{ return x >= 0 ? x : -x; }
inline long	ABS(long x)	{ return x >= 0 ? x : -x; }
inline float	ABS(float x)	{ return x >= 0 ? x : -x; }
//inline double	ABS(double x)	{ return x >= 0 ? x : -x; }
overload MAX;
inline int	MAX(int a,int b)	{ return a >= b ? a : b; }
inline long	MAX(long a,long b)	{ return a >= b ? a : b; }
inline float	MAX(float a,float b)	{ return a >= b ? a : b; }
//inline double	MAX(double a,double b)	{ return a >= b ? a : b; }
inline unsigned int	MAX(unsigned int a, unsigned int b)	{ return a >= b ? a : b; }
inline unsigned long	MAX(unsigned long a, unsigned long b)	{ return a >= b ? a : b; }
overload MIN;
inline int	MIN(int a,int b)	{ return a <= b ? a : b; }
inline long	MIN(long a,long b)	{ return a <= b ? a : b; }
inline float	MIN(float a,float b)	{ return a <= b ? a : b; }
//inline double	MIN(double a,double b)	{ return a <= b ? a : b; }
inline unsigned int	MIN(unsigned int a, unsigned int b)	{ return a <= b ? a : b; }
inline unsigned long	MIN(unsigned long a, unsigned long b)	{ return a <= b ? a : b; }



















class Object;
typedef Object* obid;
class Class;
class IdentDict;
class OrderedCltn;

class Object {
public:
	Object() {}
	void	assertArgClass(const Object& ob, const Class& expect, const char* fname);	// validate argument class
	void	assertArgSpecies(const Object& ob, const Class& expect, const char* fname);	// validate argument species
	const	Class* baseClass();				// return pointer to base class descriptor
	const	char* className();				// return class name 
	unsigned classVersion();				// return class version 
	void	derivedClassResponsibility(const char*);	// unimplemented virtual function 
	void	invalidArgClass(const Object& ob, const Class& expect, const char* fname);	// invalid object class error
	void	invalidArgSpecies(const Object& ob, const Class& expect, const char* fname);	// invalid object species error
	char	isKindOf(const Class&);			// YES if MemberOf class or a superclass 
	char	isMemberOf(const Class& clid)		{ return isA()==&clid; }
	char	isSame(const Object& ob)		{ return this==&ob; }
	char	isSpecies(const Class& clid)		{ return species()==&clid; }
	void	shouldNotImplement(const char*);	// class cannot impl this function 
	void	storeOn(fileDescTy&);			// store object in binary on file
	void	storeOn(ostream&);			// store object on stream 
	virtual obid addDependent(const Object&);	// add dependent object 
	virtual unsigned capacity();			// subclass capacity 
	virtual void changed();				// notify dependents of change 
	virtual void changed(const Object&);		// notify dependents of change 
	virtual int compare(const Object&);		// compare objects 
	virtual obid copy();				// copy defaulted as deepCopy 
	virtual obid deepCopy();			// copy with distinct instance variables 
	virtual void deepenShallowCopy();		// convert shallow copy to deep copy 
	virtual OrderedCltn& dependents();		// return list of dependent objects 
	virtual void destroyer();			// destroy object
	virtual unsigned hash();			// calculate object hash 
	virtual const Class* isA();			// return class descriptor address 
	virtual char isEqual(const Object&);		// equality test 
	virtual void scanFrom(istream& strm);		// parse object from stream 
	virtual void printOn(ostream& strm);		// print object on stream 
	virtual void release();				// remove all dependent objects 
	virtual obid removeDependent(const Object&);	// remove dependent object 
	virtual obid shallowCopy();			// copy with shared instance variables 
	virtual unsigned size();			// # of objects in array/container subclass
	virtual const Class* species();			// return species class descriptor address 
	virtual void storer(fileDescTy&);		// store this class in binary on file
	virtual void storer(ostream&);			// store this class on stream 
	virtual void update(const Object&, const Object&);	// object change notification 
	virtual void clearForReadFrom(); 		// Used to prevent memory leaks - DON'T CALL THIS FUNCTION
};

typedef void (*initorTy)(const Class&);

class Class : public Object {	// class descriptor object 
	const Class* superClass;	// pointer to this class's base class (superclass) object 
	const Class* nextClass;		// link for list of all Class objects 
	const char* class_name;		// class name 
	unsigned class_version;		// class version number 
	unsigned def_version;		
	unsigned inst_size;		// sizeof instance variables 
	void (*inst_reader)(istream&,Object&);		// object reader function 
	void (*inst_binreader)(fileDescTy&,Object&); 	// binary reader function
	initorTy class_initor2;		// phase 2 class initor
	unsigned class_number;		// class number, used by storeOn()
	friend void Object::storeOn(fileDescTy&);	
	friend void Object::storeOn(ostream&);
	friend void Object::storer(fileDescTy&);
	friend void Object::storer(ostream&);
	friend void OOPS__classInit();
public:
	Class(const Class& super, const char* name,
		unsigned version, unsigned size,
		void (*reader)(istream&,Object&), 
		void (*binreader)(fileDescTy&,Object&), 
		initorTy initor1 =0, initorTy initor2 =0);
//	Class(fileDescTy&,Class&) {}	// cfront 1.2.1 bug
//	Class(istream&,Class&) {}	// cfront 1.2.1 bug
	const Class* baseClass()		{ return superClass; }
	const char* className()			{ return class_name; }
	unsigned classNumber()			{ return class_number; }
	unsigned classNumber(unsigned n)	{ return class_number = n; }
	unsigned classVersion()			{ return class_version; }
	void reader(istream& strm, Object& where)	{ (*inst_reader)(strm,where); }
	void reader(fileDescTy& fd, Object& where)	{ (*inst_binreader)(fd,where); }
	virtual int compare(const Object&);	// compare class names 
	virtual obid deepCopy();		// shouldNotImplement 
	virtual unsigned hash();
	virtual const Class* isA();
	virtual char isEqual(const Object& ob);
	virtual void printOn(ostream& strm);
	virtual obid shallowCopy();		// shouldNotImplement 
	virtual unsigned size();
	virtual void storer(ostream&);
	virtual void storer(fileDescTy&);
};

extern Class* allClasses;	// header of list of all Classes 
extern Class class_Class;	// Class of Classes 
extern Class class_Object;
extern const obid const nil;	// pointer to sole instance of nil object 

inline const Class* Object::baseClass()	{ return isA()->baseClass(); }

 static const char* Object::className()	{ return isA()->className(); }	// static due to CC bug

inline unsigned Object::classVersion()	{ return isA()->classVersion(); }
		
inline istream& operator>>(istream& strm, Object& ob)
{
	ob.scanFrom(strm);
	return strm;
}

inline ostream& operator<<(ostream& strm, const Object& ob)
{
	ob.printOn(strm);
	return strm;
}

overload readFrom;
extern obid readFrom(istream&, const char* expectedClass ="", Object& where =*(Object*)0);	// read object from stream 
extern obid readFrom(fileDescTy&, const char* expectedClass ="", Object& where =*(Object*)0);	// read object in binary from file

extern char OOPS__Initialized;
inline char OOPSInitialized() {	return OOPS__Initialized; }

extern void OOPSIoErrCleanup();

extern void setOOPSerror(int error, int sev ...);			// decl an OOPS error condition

extern void invalidArgClass(const Object& ob, const Class& expect, const char* fname);	// invalid argument class error
extern void invalidArgSpecies(const Object& ob, const Class& expect, const char* fname);// invalid argument species error
extern void invalidClass(const Object& ob, const Class& expect);			// invalid object class error
extern void invalidSpecies(const Object& ob, const Class& expect);			// invalid object species error

inline void assertArgClass(const Object& ob, const Class& expect, const char* fname)
{
	if (!((ob).isKindOf(expect))) ::invalidArgClass(ob,expect,fname);
}

inline void assertArgSpecies(const Object& ob, const Class& expect, const char* fname)
{
	if (!((ob).isSpecies(expect))) ::invalidArgSpecies(ob,expect,fname);
}

inline void Object::assertArgClass(const Object& ob, const Class& expect, const char* fname)
{
	if (!((ob).isKindOf(expect))) this->invalidArgClass(ob,expect,fname);
}

inline void Object::assertArgSpecies(const Object& ob, const Class& expect, const char* fname)
{
	if (!((ob).isSpecies(expect))) this->invalidArgSpecies(ob,expect,fname);
}

inline void assertClass(const Object& ob, const Class& expect)
{
	if (!((ob).isKindOf(expect))) ::invalidClass(ob,expect);
}

inline void assertSpecies(const Object& ob, const Class& expect)
{
	if (!((ob).isSpecies(expect))) ::invalidSpecies(ob,expect);
}


# 29 "./Collection.hxx" 2

const unsigned CLTN_DEFAULT_CAPACITY	= 16;	// default initial collection capacity 
const unsigned CLTN_EXPANSION_INCREMENT = 32;	// collection (OrderedCltn) expansion increment 
const unsigned CLTN_EXPANSION_FACTOR = 2;	// collection (Set,Bag,Dictionary) expansion factor 





struct DoCltnPos {		
	int	index;	// used by most Collections 
	void*	ptr;	// used by LinkedLists 
	unsigned num;	// used by Bags 
	DoCltnPos()	{ index = num = 0; ptr = 0; }
};

extern Class class_Collection;

class Arrayobid;
class Bag;
class Heap;
class OrderedCltn;
class Set;
class SortedCltn;
class CollectionEnu;

class Collection: public Object {	// abstract class 
protected:
	Collection() {}
public:
	Collection(fileDescTy&,Collection&) {}
	Collection(istream&,Collection&) {}
	Arrayobid	asArrayobid();
	Bag		asBag();
	Heap		asHeap();
	OrderedCltn	asOrderedCltn();
	Set		asSet();
	SortedCltn	asSortedCltn();
	virtual	obid		add(const Object&);
	virtual const Collection& addAll(const Collection&);
	virtual Collection&	addContentsTo(Collection&);
	virtual void		deepenShallowCopy();
	virtual	obid		doNext(DoCltnPos& pos);
	virtual char		includes(const Object&);
	virtual const Class*	isA();
	virtual char		isEmpty();
	virtual unsigned	occurrencesOf(const Object&);
	virtual obid		remove(const Object&);
	virtual const Collection& removeAll(const Collection&);
	virtual obid		shallowCopy();		// shouldNotImplement
	virtual unsigned	size();
	virtual void		storer(fileDescTy&);
	virtual void		storer(ostream&);
	CollectionEnu		*newEnu();
};

class CollectionEnu: public Object {
    friend Collection;
    Collection  *Coll;
    DoCltnPos	Do;
protected:
			CollectionEnu(fileDescTy&, CollectionEnu&){}
			CollectionEnu(istream&, CollectionEnu&){}
    			CollectionEnu(Collection *C) {Coll = C;}
    virtual const Class *isA();
    virtual obid	next() {return Coll->doNext(Do);}
public:
    obid		Next(){return next();};
};


# 61 "./Arraychar.hxx" 2

extern Class class_Arraychar;

class Arraychar: public Collection {
protected:
	char* v;
	unsigned sz;
	void AllocSizeErr();
	void IndexRangeErr();
// friends go here
	friend SubString;

public:
	Arraychar(unsigned size =CLTN_DEFAULT_CAPACITY);
	Arraychar(const Arraychar&);
	~Arraychar()		{ delete v; }
	Arraychar(fileDescTy&,Arraychar&);
	Arraychar(istream&,Arraychar&);
	char& elem(int i)	{ return v[i]; }
	char operator!=(const Arraychar& a) { return !(*this==a); }
	void operator=(const Arraychar&);
	char operator==(const Arraychar&);
	char& operator[](int i)
	  { if ((unsigned)i >= sz) IndexRangeErr(); return v[i]; }
	virtual char& at(int i);
	virtual unsigned capacity();
	virtual void deepenShallowCopy();
	virtual unsigned hash();
	virtual const Class* isA();
	virtual char isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void reSize(unsigned);
	virtual unsigned size();
	virtual void sort();
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};



# 79 "Arraychar.cxx" 2
# 1 "./oopsconfig.hxx" 1


































// oopsconfig.hxx -- OOPS configuration file










// Machine Model (only one can be defined)

//#define ATT3B
//#define MASSCOMP
//#define RTPC

//#define VAX












// Operating System (only one can be defined)

//#define ACIS42
//#define AIX
//#define RTUATT
//#define RTUUCB
//#define SYSV

//#define ULTRIX










const int UNINITIALIZED	=0xa5a5a5a5;	// data value to flag uninitialized variables 

// Pseudo-random number generator 
const int MAX_INT = 0x7fffffff;
inline int DRAW(long& x)	{ return (x = x*1103515245 + 12345) & MAX_INT; }









// defines for interfacing with ASTs or signals

extern int ast_level;		// AST/signal nesting level

# 116 "./oopsconfig.hxx" 




extern int sigblock(int);
extern void sigpause(int);
extern int sigsetmask(int);












# 149 "./oopsconfig.hxx" 


# 154 "./oopsconfig.hxx" 



# 80 "Arraychar.cxx" 2
# 1 "./oopsIO.hxx" 1
























# 1 "./Object.hxx" 1
# 289 "./Object.hxx" 

# 26 "./oopsIO.hxx" 2
# 1 "/usr/include/string.h" 1


extern char
	*strcpy(),
	*strncpy(),
	*strcat(),
	*strncat(),
	*strchr(),
	*strrchr(),
	*strpbrk(),
	*strtok(),
	*strdup();
extern int
	strcmp(),
	strncmp(),
	strlen(),
	strspn(),
	strcspn();
# 27 "./oopsIO.hxx" 2
# 1 "/usr/include/stdio.h" 1


# 73 "/usr/include/stdio.h" 

# 29 "./oopsIO.hxx" 2

enum oioRecordTy {		// binary object I/O record type codes
	storeOnClassRef,	// class reference and object stored
	storeOnClass,		// class and object stored
	storeOnObjectRef	// object reference stored
};

// ascii store and read for null-terminated strings
extern void checkRead(istream&);
extern void syntaxErr(istream& strm, const char* expect, char was);
extern void store_Cstring(ostream&, const char*);
extern char* read_Cstring(istream&, char*, unsigned maxlen);







extern void oopsStoreBinErr();

extern char oopsIObuf[];
extern char *oopsGptr;
extern char *oopsPptr;
extern char *oopsEptr;
extern void oopsUnderFlow(fileDescTy& fd, char *buf);
extern void oopsOverFlow(fileDescTy& fd, char c = (-1));

inline void oopsResetIO() {oopsPptr = oopsGptr = oopsIObuf;}

inline void oopsIOflush(fileDescTy& fd) {oopsOverFlow(fd);}

inline void oopsGetc(fileDescTy& fd, char* buf) {
    if (oopsGptr >= oopsPptr) 
	oopsUnderFlow(fd, buf);
    else
	*buf = *oopsGptr++;
}

inline void oopsPutc(fileDescTy& fd, char c) {
    if (oopsEptr<=oopsPptr) 
	oopsOverFlow(fd, c); 
    else
	*oopsPptr++ = c;
}

overload readBin;
overload storeBin;

extern void storeBin(fileDescTy& fd,const char* buf,unsigned nbyte);

inline void storeBin(fileDescTy& fd,const char& val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,const unsigned char& val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,const short& val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,const unsigned short& val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,int val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,unsigned int val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,const long& val) {
	storeBin(fd,(char*)&val,sizeof(val));
	}
inline void storeBin(fileDescTy& fd,const float& val) {
	storeBin(fd,(char*)&val,sizeof(float));
	}
inline void storeBin(fileDescTy& fd,const double& val) {
	storeBin(fd,(char*)&val,sizeof(double));
	}
inline void storeBin(fileDescTy& fd,const char* val) {
	storeBin(fd,strlen(val));
	storeBin(fd,val,strlen(val));
	}
inline void storeBin(fileDescTy& fd,const short* val,unsigned size) {
	storeBin(fd,size);
	storeBin(fd,(char*)val,size*sizeof(*val));
	}
inline void storeBin(fileDescTy& fd,const int* val,unsigned size) {
	storeBin(fd,size);
	storeBin(fd,(char*)val,size*sizeof(*val));
	}
inline void storeBin(fileDescTy& fd,const long* val,unsigned size) {
	storeBin(fd,size);
	storeBin(fd,(char*)val,size*sizeof(*val));
	}
inline void storeBin(fileDescTy& fd,const float* val,unsigned size) {
	storeBin(fd,size);
	storeBin(fd,(char*)val,size*sizeof(*val));
	}
inline void storeBin(fileDescTy& fd,const double* val,unsigned size) {
	storeBin(fd,size);
	storeBin(fd,(char*)val,size*sizeof(*val));
	}

extern void readBin(fileDescTy& fd,char* buf,unsigned nbyte);

inline void readBin(fileDescTy& fd,char& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,unsigned char& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,short& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,unsigned short& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,int& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,unsigned int& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,long& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,float& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,double& val) {
	readBin(fd,(char*)&val,sizeof(val));
	}
inline void readBin(fileDescTy& fd,short* val,unsigned size) {
	readBin(fd,(char*)val,size*sizeof(*val));
	}
inline void readBin(fileDescTy& fd,int* val,unsigned size) {
	readBin(fd,(char*)val,size*sizeof(*val));
	}
inline void readBin(fileDescTy& fd,long* val,unsigned size) {
	readBin(fd,(char*)val,size*sizeof(*val));
	}
inline void readBin(fileDescTy& fd,float* val,unsigned size) {
	readBin(fd,(char*)val,size*sizeof(*val));
	}
inline void readBin(fileDescTy& fd,double* val,unsigned size) {
	readBin(fd,(char*)val,size*sizeof(*val));
	}

# 82 "Arraychar.cxx" 2



overload Arraychar_reader; static void Arraychar_reader(istream& strm, Object& where) { new Arraychar(strm,*(Arraychar*)&where); }static void Arraychar_reader(fileDescTy& fd, Object& where) { new Arraychar(fd,*(Arraychar*)&where); }Class class_Arraychar = Class( class_Collection, "Arraychar", 1, sizeof(Arraychar), Arraychar_reader, Arraychar_reader, 0, 0 ); const Class* Arraychar::isA() { return &class_Arraychar; };

static int charCmp(char* a, char* b)
{
	return *(unsigned char*)a - *(unsigned char*)b;
}

static union hash_char_mask {
	unsigned in[sizeof(int)];
	char ch[sizeof(int)*sizeof(int)];
	hash_char_mask();
} mask;

static hash_char_mask::hash_char_mask()
{
	for (register unsigned i=0; i<sizeof(int); i++) {
		for (register unsigned j=0; j<sizeof(int); j++) ch[sizeof(int)*i+j] = j<i ? 0xff : 0;
	}
}

unsigned Arraychar::hash()
{
	register unsigned h = sz;

	register unsigned i = sz >> 2;
# 112 "Arraychar.cxx" 

	register unsigned* vv = (unsigned*)v;
	while (i--) h ^= *vv++;

	if ((i = sz&(sizeof(int)-1)) != 0)
# 119 "Arraychar.cxx" 

		h ^= *vv & mask.in[i];
	return h;
}

void Arraychar::printOn(ostream& strm)
{
	strm << Arraychar() << "[";
	for (register unsigned i=0; i<sz; i++) {
		strm << "\t" << form("0x%.2x",(unsigned int)(unsigned char)v[i]);
	}
	strm << "]\n";
}

Arraychar::Arraychar(istream& strm, Arraychar& where)
{
	this = &where;
	strm >> sz;
	v = new char[sz];
	for (register unsigned i =0; i<sz; i++) { int _i; strm >> _i; v[i] = _i; }
}

void Arraychar::storer(ostream& strm)
{
	Object::storer(strm);
	strm << sz << " ";
	for (register unsigned i=0; i<sz; i++) strm << (unsigned int)(unsigned char)v[i] << " ";
}

Arraychar::Arraychar(fileDescTy& fd, Arraychar& where)
{
	this = &where;
	readBin(fd,sz);
	v = new char[sz];
	readBin(fd,v,sz);
}

void Arraychar::storer(fileDescTy& fd) 
{
	Object::storer(fd);
	storeBin(fd,sz);
	storeBin(fd,v,sz);
}

Arraychar::Arraychar(unsigned size)
{
	sz = size;
	if (size<=0) AllocSizeErr();
	else v = new char[sz];
}

Arraychar::Arraychar(const Arraychar& a)
{
	register unsigned i = a.sz;
	sz = i;
	v = new char[i];
	register char* vv = &v[0];
	register char* av = &a.v[0];
	while (i--) *vv++ = *av++;
}

void Arraychar::operator=(const Arraychar& a)
{
	if (v != a.v) {
		delete v;
		v = new char[sz=a.sz];
		register unsigned i = a.sz;
		register char* vv = &v[0];
		register char* av = &a.v[0];
		while (i--) *vv++ = *av++;
	}
}

char Arraychar::operator==(const Arraychar& a)
{
	if (sz != a.sz) return NO;
	register unsigned i = sz;
	register char* vv = &v[0];
	register char* av = &a.v[0];
	while (i--) if (*vv++ != *av++) return NO;
	return YES;
}

char& Arraychar::at(int i)
{
	return this->operator[](i);
}

unsigned Arraychar::capacity()	{ return sz; }

char Arraychar::isEqual(const Object& a)
{
	return a.isSpecies(class_Arraychar) && *this==*(Arraychar*)&a;
}

const Class* Arraychar::species()	{ return &class_Arraychar; }

void Arraychar::reSize(unsigned newsz)
{
	if (newsz<=0) AllocSizeErr();
	char* newv = new char[newsz];
	register unsigned i = (newsz<=sz) ? newsz:sz;
	register char* vp = &v[0];
	register char* np = &newv[0];
	while (i--) *np++ = *vp++;
	delete v;
	v = newv;
	sz = newsz;
}

void Arraychar::deepenShallowCopy()
{
	Collection::deepenShallowCopy();
	register char* av = &v[0];
	register unsigned i = sz;
	v = new char[i];
	register char* vv = &v[0];
	while (i--) *vv++ = *av++;
}

unsigned Arraychar::size()	{ return sz; }

void Arraychar::sort()
{
	qsort(v,sz,sizeof(char),charCmp);
}

extern const int OOPS_ALLOCSIZE;
extern const int OOPS_INDEXRANGE;

void Arraychar::AllocSizeErr()
{
	setOOPSerror(OOPS_ALLOCSIZE,DEFAULT,this,className());
}
void Arraychar::IndexRangeErr()
{
	setOOPSerror(OOPS_INDEXRANGE,DEFAULT,this,className());
}

