/* Array.c.m4 -- template for implementations of generic array objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:

m4 macro template for the .c files for arrays of the specified
fundamental type: char, int, short, long, unsigned, float, and double.
For example, to generate the implementation of an array of chars:

	m4 Array.c.m4 Arraychar.p >Arraychar.c

The type-specific part of the implementation is in the file
Arraychar.p, for example.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

Modification History:

*/


/* Arraychar.p -- type-specific functions for class Arraychar

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:
	
Type-specific functions for class Arraychar, such as hash() and
printOn().  Generic functions are generated from the m4 template file
Array.c.m4.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

Modification History:

26-Feb-87	K. E. Gorlen

1.  Quote preprocessor commands for compatibility with 4.2BSD m4.

28-Oct-86	K. E. Gorlen

1.  Made generic by using m4 macros.

07-Oct-86	S. M. Orlow

1.  Adapted from Array.h and Arrayimp.h because the macros were
    defeating the preprocessor.
*/

#include "Arraychar.hxx"
#include "oopsconfig.hxx"
#include <libc.hxx>
#include "oopsIO.hxx"

#define	THIS	Arraychar
#define	BASE	Collection
DEFINE_CLASS(Arraychar,Collection,1,NULL,NULL);

static int charCmp(char* a, char* b)
{
	return *(unsigned char*)a - *(unsigned char*)b;
}

static union hash_char_mask {
	UNSIGNED in[sizeof(int)];
	char ch[sizeof(int)*sizeof(int)];
	hash_char_mask();
} mask;

static hash_char_mask::hash_char_mask()
{
	for (register UNSIGNED i=0; i<sizeof(int); i++) {
		for (register UNSIGNED j=0; j<sizeof(int); j++) ch[sizeof(int)*i+j] = j<i ? 0xff : 0;
	}
}

UNSIGNED THIS::hash()
{
	register UNSIGNED h = sz;
#ifdef LOG2_INT
	register UNSIGNED i = sz >> LOG2_INT;
#else
	register UNSIGNED i = sz/sizeof(int);
#endif
	register UNSIGNED* vv = (UNSIGNED*)v;
	while (i--) h ^= *vv++;
#ifdef LOG2_INT
	if ((i = sz&(sizeof(int)-1)) != 0)
#else
	if ((i = sz%sizeof(int)) != 0)
#endif
		h ^= *vv & mask.in[i];
	return h;
}

void THIS::printOn(ostream& strm)
{
	strm << Arraychar() << "[";
	for (register UNSIGNED i=0; i<sz; i++) {
		strm << "\t" << form("0x%.2x",(unsigned int)(unsigned char)v[i]);
	}
	strm << "]\n";
}

THIS::THIS(istream& strm, THIS& where)
{
	this = &where;
	strm >> sz;
	v = new char[sz];
	for (register UNSIGNED i =0; i<sz; i++) { int _i; strm >> _i; v[i] = _i; }
}

void THIS::storer(ostream& strm)
{
	Object::storer(strm);
	strm << sz << " ";
	for (register UNSIGNED i=0; i<sz; i++) strm << (unsigned int)(unsigned char)v[i] << " ";
}

Arraychar::Arraychar(fileDescTy& fd, Arraychar& where)
{
	this = &where;
	readBin(fd,sz);
	v = new char[sz];
	readBin(fd,v,sz);
}

void Arraychar::storer(fileDescTy& fd) 
{
	Object::storer(fd);
	storeBin(fd,sz);
	storeBin(fd,v,sz);
}

Arraychar::Arraychar(UNSIGNED size)
{
	sz = size;
	if (size<=0) AllocSizeErr();
	else v = new char[sz];
}

Arraychar::Arraychar(const Arraychar& a)
{
	register UNSIGNED i = a.sz;
	sz = i;
	v = new char[i];
	register char* vv = &v[0];
	register char* av = &a.v[0];
	while (i--) *vv++ = *av++;
}

void Arraychar::clearForReadFrom() {delete v;}

void Arraychar::operator=(const Arraychar& a)
{
	if (v != a.v) {
		delete v;
		v = new char[sz=a.sz];
		register UNSIGNED i = a.sz;
		register char* vv = &v[0];
		register char* av = &a.v[0];
		while (i--) *vv++ = *av++;
	}
}

bool Arraychar::operator==(const Arraychar& a)
{
	if (sz != a.sz) return NO;
	register UNSIGNED i = sz;
	register char* vv = &v[0];
	register char* av = &a.v[0];
	while (i--) if (*vv++ != *av++) return NO;
	return YES;
}

char& Arraychar::at(int i)
{
	return this->operator[](i);
}

UNSIGNED Arraychar::capacity()	{ return sz; }

bool Arraychar::isEqual(const Object& a)
{
	return a.isSpecies(class_Arraychar) && *this==*(Arraychar*)&a;
}

const Class* Arraychar::species()	{ return &class_Arraychar; }

void Arraychar::reSize(UNSIGNED newsz)
{
	if (newsz<=0) AllocSizeErr();
	char* newv = new char[newsz];
	register UNSIGNED i = (newsz<=sz) ? newsz:sz;
	register char* vp = &v[0];
	register char* np = &newv[0];
	while (i--) *np++ = *vp++;
	delete v;
	v = newv;
	sz = newsz;
}

void Arraychar::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	register char* av = &v[0];
	register UNSIGNED i = sz;
	v = new char[i];
	register char* vv = &v[0];
	while (i--) *vv++ = *av++;
}

UNSIGNED Arraychar::size()	{ return sz; }

void Arraychar::sort()
{
	qsort(v,sz,sizeof(char),charCmp);
}

extern const int OOPS_ALLOCSIZE;
extern const int OOPS_INDEXRANGE;

void Arraychar::AllocSizeErr()
{
	setOOPSerror(OOPS_ALLOCSIZE,DEFAULT,this,className());
}
void Arraychar::IndexRangeErr()
{
	setOOPSerror(OOPS_INDEXRANGE,DEFAULT,this,className());
}

