#include	<math.h>	/* this for HUGE definition */
/*
 * pslsin, pslcos, and psltan routines.
 *	Return the sin, cos, &/| tan of the argument angle which is
 *	expressed in psls.  (32768 psls == pi radians).
 */

#define	PI		0x8000
#define	PI_OVER_TWO	0x4000
#define	PIMASK		0x7FFF

float sintab[] = {
	0.00000,0.00614,0.01227,0.01841,0.02454,0.03067,0.03681,0.04294,
	0.04907,0.05520,0.06132,0.06744,0.07356,0.07968,0.08580,0.09191,
	0.09802,0.10412,0.11022,0.11632,0.12241,0.12850,0.13458,0.14066,
	0.14673,0.15280,0.15886,0.16491,0.17096,0.17700,0.18304,0.18907,
	0.19509,0.20111,0.20711,0.21311,0.21910,0.22508,0.23106,0.23702,
	0.24298,0.24893,0.25487,0.26079,0.26671,0.27262,0.27852,0.28441,
	0.29029,0.29615,0.30201,0.30785,0.31368,0.31950,0.32531,0.33111,
	0.33689,0.34266,0.34842,0.35416,0.35990,0.36561,0.37132,0.37701,
	0.38268,0.38835,0.39399,0.39962,0.40524,0.41084,0.41643,0.42200,
	0.42756,0.43309,0.43862,0.44412,0.44961,0.45508,0.46054,0.46598,
	0.47140,0.47680,0.48218,0.48755,0.49290,0.49823,0.50354,0.50883,
	0.51410,0.51936,0.52459,0.52980,0.53500,0.54017,0.54533,0.55046,
	0.55557,0.56066,0.56573,0.57078,0.57581,0.58081,0.58580,0.59076,
	0.59570,0.60062,0.60551,0.61038,0.61523,0.62006,0.62486,0.62964,
	0.63439,0.63912,0.64383,0.64851,0.65317,0.65781,0.66242,0.66700,
	0.67156,0.67609,0.68060,0.68508,0.68954,0.69397,0.69838,0.70276,
	0.70711,0.71143,0.71573,0.72000,0.72425,0.72846,0.73265,0.73682,
	0.74095,0.74506,0.74914,0.75319,0.75721,0.76120,0.76517,0.76910,
	0.77301,0.77689,0.78074,0.78456,0.78835,0.79211,0.79584,0.79954,
	0.80321,0.80685,0.81046,0.81404,0.81759,0.82110,0.82459,0.82805,
	0.83147,0.83486,0.83823,0.84156,0.84485,0.84812,0.85136,0.85456,
	0.85773,0.86087,0.86397,0.86705,0.87009,0.87310,0.87607,0.87901,
	0.88192,0.88480,0.88764,0.89045,0.89322,0.89597,0.89867,0.90135,
	0.90399,0.90660,0.90917,0.91171,0.91421,0.91668,0.91911,0.92151,
	0.92388,0.92621,0.92851,0.93077,0.93299,0.93518,0.93734,0.93946,
	0.94154,0.94359,0.94561,0.94759,0.94953,0.95144,0.95331,0.95514,
	0.95694,0.95870,0.96043,0.96212,0.96378,0.96540,0.96698,0.96852,
	0.97003,0.97150,0.97294,0.97434,0.97570,0.97703,0.97832,0.97957,
	0.98079,0.98196,0.98311,0.98421,0.98528,0.98631,0.98730,0.98826,
	0.98918,0.99006,0.99090,0.99171,0.99248,0.99321,0.99391,0.99457,
	0.99519,0.99577,0.99631,0.99682,0.99729,0.99772,0.99812,0.99848,
	0.99880,0.99908,0.99932,0.99953,0.99970,0.99983,0.99993,0.99998,
	1.00000
};

double
pslsin(angle)
int angle;
{
	register int a, sign;
	double sin;

	a = (angle + 040) & ~077;			   /* half adjust */
	sign = a & PI;					 /* pick quadrant */
	a &= PIMASK;				/* get rid of mults of PI */
	a = (a & PI_OVER_TWO)? PI - a : a;
	a >>= 6;				  /* reduce to table size */
	sin = sign ? -sintab[a] : sintab[a];
	return(sin);
}

double
pslcos(angle)
int angle;
{
	return(pslsin(angle + PI_OVER_TWO));
}

double psltan(angle)
int angle;
{
	if ((angle & PIMASK) == PI_OVER_TWO)
	    return(HUGE);
	return(pslsin(angle) / pslsin(angle + PI_OVER_TWO));
}

double
ipslsin(angle)
int angle;
{
	int interp;
	double h, l;

	interp = angle & 077;
	angle &= ~077;
	l = pslsin(angle);
	h = pslsin(angle + 0100);
	return(l + interp * (h - l) / 0100);
}

double
ipslcos(angle)
int angle;
{
	return(ipslsin(angle + PI_OVER_TWO));
}

double
ipsltan(angle)
int angle;
{
	if ((angle & PIMASK) == PI_OVER_TWO)
	    return(HUGE);
	return(ipslsin(angle) / ipslsin(angle + PI_OVER_TWO));
}
