#include "uupurge.h"

/*******
 *	uupurge - move and remove uucp spool files
 *         PURPOSE: 
 *         Intended for uucp disasters. Should be mostly of
 *         use for extricating mail from news in the uucp spooling
 *   	   directory. Files for a given remote system can be copied
 *         to a directory which you must have created beforehand.
 *         Also files for non-news (mail mostly)  only can be copied. 
 *         News for a target system or news only may be deleted 
 *         from the spooler. Note that all of the spool files for the
 *         specified system have to go somewhere or else be removed.
 *         You cannot move part of the files out and leave part
 *         of them in the spooler due to the way the directory
 *         is read. Also note that this will not do anything
 *         about X. files that have not been "executed" or fed to
 *         uuxqt yet. X. files and related data files are left alone.	
 *         Further it is only executable by root.
 *
 *         See argscan.c and manual page for switch definitions.
 *
 *         Examples will appear with: uupurge -h
 *
 *         THIS IS A HACK AND IS NOT MEANT TO BE MORE. 
 *
 *                         Tektronix - 1/28/83 -  James Binkley 
 *      
 *      EXTERNALS:
 *         constants: 
 *                   
 *         vars:    
 *                  SPOOLDIR
 *                  Cprefix
 *                  sflag
 *      CALLS:
 *       
 *           	ARGSCAN  - argscan.c
 *           	chdir    - UPM(2) 
 *           	fprintf  - UPM(3)
 *           	strcpy   - UPM(3)
 *           	strcat   - UPM(3)
 *           	CALLS    - this is a macro...
 *           	getworklist  - getwklist.c
 *           	dispatch     - dispatch.c	
 *       
 *      CALLED BY:
 *
 *	return codes:
 *    
 */ 


main(argc, argv)
char *argv[];
{
	int Iswork;

/* 
 *   handle input arguments
 */
	ARGSCAN(argc,argv);   
/*
 *   chdir to spool dir
 */

	chdir(SPOOLDIR);

        if (Debug) {
		fprintf(stderr,"destdir is %s\n",destdir);
		fprintf(stderr,"ndestdir is %s\n",ndestdir);
        }
 
/* 
 * define the prefix for C files that we will use
 */

	strcpy(Cprefix,"C.");
	if ( sflag )
	   strcat(Cprefix,Rmtname);
  
        if (Debug) {
                fprintf(stderr,"Cprefix is %s\n",Cprefix);
        }
  
/*
 *  while there is work meaning C files with the proper prefix
 *      get a worklist
 *      process the worklist
 *
 */
       Iswork = WORK;
       while ( Iswork ) {
	   CALLS(main,getworklist);
           Iswork = getworklist(SPOOLDIR,Cprefix,worknames);
	   if (Iswork) {
	        CALLS(main,dispatch);
		dispatch();
           }
       }
}
