#include "uupurge.h"
#include <sys/types.h>
#include <sys/stat.h>



/***
 *	getworklist(dir, pre, workfiles)
 *	char *dir,             input: -  directory to be opened
 *      char *pre,             input: -  machine name prefix 
 *                                       with which to match 
 *      char (*list)[UFILESIZ] output: - external static array for  
					 list of workfiles
 *      PURPOSE:
 *         returns a list of file names that
 *         match the given prefix.
 *
 *
 *      EXTERNALS:
 *          constants: MAXWORK - max no of possible workfiles 
 *                               ROW size of workfiles
 *                     UFILSIZE - size of unix file name
 *          vars:      workfiles  -  workfiles static array
 *                     Nojobs     -  no of C files found in directory
 *      CALLS:
 *          fopen()   - UPM(3)
 *          fclose()  - UPM(3)
 *          strcpy()  - UPM(3)
 *          stat()    - UPM(2)
 *          getdirent() - getdirent.c
 *          prefix()  - prefix.c
 *      CALLED BY:
 *          main in rutrans.c
 *
 *	return codes:  
 *              NOWORK   0        - cannot find any work
 *              WORK     1        - there is work to do
 */

#define ANYREAD 04

getworklist(dir, pre, workfiles)
char *dir, *pre, (*workfiles)[UFILESIZ];
{
	struct stat s;

	char **first, **last;
	FILE *pdir;
	extern int compar();
        char tempfile[UFILESIZ];
        FILE *fopen();

        Nojobs = 0;

	/* open spool directory
	 */
	if ((pdir = fopen(dir, "r")) == NULL)  {
		fprintf(stderr,"cannot open uucp spool dir\n");
		exit(0);
        }

	/* loop while we do not have MAXWORK
	 * number of work files read in the internal
	 * workfiles buffer
	 */

        while ( Nojobs < MAXWORK ) {
		int i;

		for ( i = 0; i < UFILESIZ;  i++)
		   tempfile[i] = NULL;

                /*  get a directory entry and write it in
		 *  tempfile
		 */

	        if( getdirent(pdir, tempfile) == 0 )  {
		   break;
                }
			
                /* check for correct prefix
		 */
			
		if (!prefix(pre, tempfile))
			continue;
                /* check for file existence
		 */
		if (stat(tempfile, &s) == -1)
			continue;
		if ((s.st_mode & ANYREAD) == 0)
			continue;
                strcpy(*workfiles,tempfile);	
	        *workfiles++;
		Nojobs++;
	}

	fclose(pdir);

	if ( Nojobs == 0 )
	    return(NOWORK);
        else
	    return(WORK);
}
