   
/*
 * Tektronix 8560 Unix - Unix Copy
 *
 *	Based on Western Electric System III Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */


#ifdef SCCSID
static char *sccsid = "@(#)@(#)getsitenm.c	5.1 (82/12/08) Tektronix 8560 Unix";
#endif

/*	@(#)getsitenm.c	1.1	82/08/10	8/10/82	*/
/*
 * simulate the 4.2a bsd system call by reading /usr/include/whoami.h
 * and looking for the #define sitename
 */

#include <stdio.h>

#ifdef DEBUG
#define HDRFILE "whoami.h"
#else
#define	HDRFILE "/usr/include/whoami.h"
#endif

getsitename(name, len)
char *name;
int len;
{
	char buf[BUFSIZ];
	char sname[32];
	FILE *fd;
	
	fd = fopen(HDRFILE, "r");
	if (fd == NULL)
		return(-1);
	
	for (;;) {	/* each line in the file */
		if (fgets(buf, sizeof buf, fd) == NULL) {
			strncpy(name, "siteunknown", len);
			goto out;
		}
		if (sscanf(buf, "#define sitename \"%[^\"]\"", sname) == 1) {
			strncpy(name, sname, len);
			goto out;
		}
	}
out:
	fclose(fd);
	return(0);
}
