#include "uupurge.h"


/* read_job(cfname)
 * char *cfname   input: name of control file (C.whatever)
 *    PURPOSE: 
 *      will read in a uucp workfile into internal
 *      structures. The workfile has a C prefix and 
 *      contain references to data files that are meant for
 *      transmission. In the case of a SEND ('S'),
 *      there will be one line per data file
 *      in the C file. The first data file is meant to be
 *      a source file. The second if it exists is information
 *      meant for remote execution on the remote machine.
 *      read_job will read in information in the C file and
 *      information in the remote execution file if it 
 *      exists.
 *      
 *      EXTERNALS:
 *         constants:   EXEC 
 *                      DATAONLY
 *         vars:        
 *      CALLS:
 *           fopen()        - UPM(3)
 *           sprintf()      - UPM(3)
 *           fgets()        - UPM(3)
 *           getargs()      - getargs.c
 *           getexecfile()  - this file
 *      CALLED BY:
 *           
 *	return codes:
 *           EXEC - given item of work has two
 *                  associated files - ie remote
 *                  execution
 *           DATAONLY - data transmission only
 *           NOFILE - cannot open file
 *
 */

 read_job(cfname)
 char *cfname;


 {
       FILE *fd; 
       FILE *fopen();
       char errmsg[BUFSIZE];   /* temp buf for any error messages */
       int i;
       int mode;               /* returned mode */
       int rc;                 /* return status of some subroutine */
       int j;
       char tempstr[BUFSIZE];  

       /* open the control file
	*/

       fd = fopen(cfname,"r");
       if (fd == NULL)   {
	   fprintf(stderr,"fatal error: cannot open workfile %s\n",cfname);
	   if (!iflag)
	        exit(0);
           else
		return(NOFILE);
       }

       /* read in strings - 1 string per involved
	* data file - should only be two maximum
	* set mode according to number of strings 
	*/
      
       i = 0;
       mode = DATAONLY;
       while ( fgets(tempstr,BUFSIZE,fd) != NULL ) {
	       if (i == 0) {
		    getargs(tempstr,Dvec);
	       }
	       if ( i == 1 ) {
		    mode = EXEC;
		    getargs(tempstr,DXvec);
               }
	       if ( ++i >= 2)
		  break;
       }
   

       fclose(fd);

       /* 
        * if not simple file transmission
	* call getexecfile to get args for 
	* command execution
	*/
       if (mode == EXEC)
	    getexecfile(DXDFNAME);

       return(mode);
}

/* getexecfile
 *      PURPOSE: 
 *           - get the information out of a D.<machine name>X file
 *             intended for remote execution on the remote system
 *      
 *      EXTERNALS:
 *         constants:  BUFSIZE
 *                   
 *         vars:    
 *      CALLS:
 *             fopen    - UPM(3)
 *             sprintf  - UPM(3)
 *             logent   - ../logent.c
 *             fgets    - UPM(3)
 *             getargs  - getargs.c
 *             strcmp   - 
 *      CALLED BY:
 *             read_job() - this module
 *	return codes:
 *             NOFILE - cannot open file
 */
char *tvec[10];

getexecfile(fname)
char *fname;
{
       FILE *fd; 
       FILE *fopen();
       char errmsg[BUFSIZE];
       char tempstr[BUFSIZE];
       int rc;
       int j;
       int i;

       fd = fopen(fname,"r");
       if (fd == NULL)   {
	   
	   fprintf(stderr,"fatal error: cannot open execfile %s\n",fname);
	   if (!iflag)
	       exit(0);
           else
	       return(NOFILE);
       }

       while (   fgets (tempstr,BUFSIZE,fd)  != NULL ) {
	     int k;

	     for (k = 0; k < 10; k++)
		 tvec[k] = NULL;
             switch (tempstr[0])  {

		 case 'U':
			  getargs(tempstr,tvec);
			  U_USER = tvec[1];
			  U_RMTSYS = tvec[2];
			  break;
		 case 'F':
			  getargs(tempstr,tvec);
			  F_FNAME = tvec[1];
			  F_BASENAME = tvec[2];
			  break;
		 case 'I':
			  getargs(tempstr,tvec);
			  I_STDIN = tvec[1];
			  break;
		 case 'O':
			  getargs(tempstr,tvec);
			  O_STDOUT = tvec[1];
			  O_SYSNAME = tvec[2];
			  break;
		 case 'C':
			  getargs(tempstr,tvec);
			  C_COM  = tvec[1];
			  if ( strcmp(C_COM,"uusend") ==  0 )  
			      C_ARGS = tvec[5];
			  else
			      C_ARGS = tvec[2];
			  break;
             }
      }

      fclose(fd);
}  
