/*      copy(from,to)
 *          char *from;   input - name of file to copy from
 *          char *to;     input - name of file to be created
 *      PURPOSE:
 *          copy first file to second file. This is directly
 *          filched and unmodified from Unix "cp" command...
 *      EXTERNALS:
 *         constants: 
 *                   
 *         vars:    
 *      CALLS:
 *          open       -  UPM(2)
 *          fprintf    -  UPM(3)
 *          fstat      -  UPM(2)
 *          stat       -  UPM(2)
 *          creat      -  UPM(2)
 *          close      -  UPM(2)
 *          read       -  UPM(2)
 *          write      -  UPM(2)
 *
 *      CALLED BY:
 *          move       -  dispatch.c
 *	return codes:
 *            0  - success
 *            1  - failure
 */


#define	BSIZE	512
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
struct	stat	stbuf1, stbuf2;
char	iobuf[BSIZE];

copy(from, to)
char *from, *to;
{
	int fold, fnew, n;
	register char *p1, *p2, *bp;
	int mode;
	if ((fold = open(from, 0)) < 0) {
		fprintf(stderr, "cp: cannot open %s\n", from);
		return(1);
	}
	fstat(fold, &stbuf1);
	mode = stbuf1.st_mode;
	/* is target a directory? */
	if (stat(to, &stbuf2) >=0 &&
	   (stbuf2.st_mode&S_IFMT) == S_IFDIR) {
		p1 = from;
		p2 = to;
		bp = iobuf;
		while(*bp++ = *p2++)
			;
		bp[-1] = '/';
		p2 = bp;
		while(*bp = *p1++)
			if (*bp++ == '/')
				bp = p2;
		to = iobuf;
	}
	if (stat(to, &stbuf2) >= 0) {
		if (stbuf1.st_dev == stbuf2.st_dev &&
		   stbuf1.st_ino == stbuf2.st_ino) {
			fprintf(stderr, "cp: cannot copy file to itself.\n");
			return(1);
		}
	}
	if ((fnew = creat(to, mode)) < 0) {
		fprintf(stderr, "cp: cannot create %s\n", to);
		close(fold);
		return(1);
	}
	while(n = read(fold,  iobuf,  BSIZE)) {
		if (n < 0) {
			fprintf(stderr, "cp: read error\n");
			close(fold);
			close(fnew);
			return(1);
		} else
			if (write(fnew, iobuf, n) != n) {
				fprintf(stderr, "cp: write error.\n");
				close(fold);
				close(fnew);
				return(1);
			}
	}
	close(fold);
	close(fnew);
	return(0);
}
