/*
 * Tektronix 8560 Unix - Unix Copy
 *
 *	Based on Western Electric System III Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */


#ifdef SCCSID
static char *sccsid = "@(#)@(#)conn.c	5.1 (82/12/08) Tektronix 8560 Unix";
#endif

	/*  conn 3.12  1/5/80  13:51:15  */
#define CONN
#include "uucp.h"
#include <signal.h>
#include <setjmp.h>
#include <ctype.h>
#include <sys/types.h>
#include <time.h>
#include "fcntl.h"

#ifndef TNIX
#include <sgtty.h>
#else
#include <sys/tiop.h>
#endif

static char SiD[] = "@(#)conn	3.12";

#if  TEK_UNET && TEK_4_1A
ERROR!!!!!!!!!!!!!!
#endif

#ifdef  TEK_UNET
#include <unetconfig.h>
#include <unetio.h>
#include <tcp.h>

int     use_unet = 0;
#define ioctl   Uioctl
#endif


#ifdef TEK_4_1A
#include <sys/socket.h>
#include <net/in.h>
#define ioctl   Uioctl

struct	sockaddr_in hisaddr = { AF_INET };
int     use_unet = 0;
#endif


#ifdef DATAKIT
#include <dk.h>
#endif

#define MAXPH 60

#define F_NAME 0
#define F_TIME 1
#define F_LINE 2
#define F_CLASS 3	/* an optional prefix and the speed */
#define F_SPEED 3
#define F_PHONE 4
#define F_LOGIN 5

jmp_buf Sjbuf;
int alarmtr();

#define INVOKE(a, r) ret = a; if (ret<0) return(r);

/*******
 *	conn(system)
 *	char *system;
 *
 *	conn - place a telephone call to system and
 *	login, etc.
 *
 *	return codes:
 *		CF_SYSTEM: don't know system
 *		CF_TIME: wrong time to call
 *		CF_DIAL: call failed
 *		CF_LOGIN: login/password dialog failed
 *
 *		>0  - file no.  -  connect ok
 *
 */

conn(system)
char *system;
{
	int ret, nf;
	int fn;
	char *flds[50];
	FILE *fsys;
	int fcode = 0;


	fsys = fopen(SYSFILE, "r");
	ASSERT(fsys != NULL, "CAN'T OPEN", SYSFILE, 0);
	DEBUG(4, "finds %s\n", "called");
	while((nf = finds(fsys, system, flds)) > 0) {
		DEBUG(4, "getto %s\n", "called");
		if ((fn = getto(flds)) > 0)
			break;
		fcode = CF_DIAL;
	}
	fclose(fsys);
	if (nf < 0)
		return(fcode ? fcode : nf);

	DEBUG(4, "login %s\n", "called");
	INVOKE(login(nf, flds, fn), CF_LOGIN)
	return(fn);
}


	/* This structure tells about a device */
struct Devices {
	char D_type[10];
	char D_line[10];
	char D_calldev[10];
	char D_class[10];
	int D_speed;
	};
/***
 *	getto(flds)		connect to remote machine
 *	char *flds[];
 *
 *	return codes:
 *		>0  -  file number - ok
 *		FAIL  -  failed
 */

getto(flds)
char *flds[];
{
	DEBUG(4, "call: no. %s ", flds[F_PHONE]);
	DEBUG(4, "for sys %s ", flds[F_NAME]);

	if (prefix("ACU", flds[F_LINE])) 
		return(call(flds));

#ifdef DATAKIT
	else if (prefix("DK", flds[F_LINE]))
		return(dkcall(flds));
#endif
#ifdef TEK_UNET
	else if (prefix("UNET", flds[F_LINE]))
	{
		use_unet = tcpopen(flds[F_NAME],23,0,TO_ACTIVE,"rw");
		return(use_unet);
	}
	else if (prefix("XUNET", flds[F_LINE]))
	{
		use_unet = tcpopen(flds[F_NAME],251,0,TO_ACTIVE,"rw");
		return(use_unet);
	}
#endif
#ifdef TEK_4_1A
	else if (prefix("XUNET", flds[F_LINE]))
	{
		use_unet = sockopen (IPPORT_UUCP, flds[F_NAME]);
		return(use_unet);
	}
#endif
	else
		return(direct(flds));
}

#ifdef TEK_4_1A
sockopen(remoteport, nameptr)
	u_short remoteport;
	char	*nameptr;
{
	u_long rhostaddr;
	int nfd;

	rhostaddr = rhost(&nameptr);
	if (rhostaddr == -1) {
		fprintf(stderr, "%s: Unknown host.\n", nameptr);
		return(FAIL);
	}
	hisaddr.sin_addr.s_addr = rhostaddr;

	hisaddr.sin_port = remoteport;
#if vax || pdp11
	hisaddr.sin_port = htons(hisaddr.sin_port);
#endif
	nfd = socket(SOCK_STREAM, 0, (struct sockaddr *)0, 0);
	if (nfd < 0) {
		perror("sockopen socket call error");
		return(FAIL);
	}
	if (connect(nfd, &hisaddr)) {
		perror("sockopen socket connect error");
		return(FAIL);
	}
	return (nfd);
}
#endif

/***
 *	call(flds)		call remote machine
 *	char *flds[];
 *
 *	"flds" contains the call information (name, date, type, speed,
 *	phone no. ...
 *	Ndev has the device no.
 *
 *	return codes:
 *		>0  -  file number  -  ok
 *		FAIL  -  failed
 */

call(flds)
char *flds[];
{
	char phone[MAXPH+1];
	int dcr, i;

	exphone(flds[F_PHONE], phone);
	for (i = 0; i < TRYCALLS; i++) {
		DEBUG(4, "Dial %s\n", phone);
		dcr = dialup(phone, flds);
		DEBUG(4, "dcr returned as %d\n", dcr);
		if (dcr != FAIL)
			break;
	}
	return(dcr);

}


/***
 *	exphone - expand phone number for given prefix and number
 *
 *	return code - none
 */

exphone(in, out)
char *in, *out;
{
	FILE *fn;
	char pre[MAXPH], npart[MAXPH], tpre[MAXPH], p[MAXPH];
	char buf[BUFSIZ];
	char *s1;

	if (!isalpha(*in)) {
		strcpy(out, in);
		return;
	}

	s1=pre;
	while (isalpha(*in))
		*s1++ = *in++;
	*s1 = '\0';
	s1 = npart;
	while (*in != '\0')
		*s1++ = *in++;
	*s1 = '\0';

	tpre[0] = '\0';
	fn = fopen(DIALFILE, "r");
	if (fn != NULL) {
		while (fgets(buf, BUFSIZ, fn)) {
			sscanf(buf, "%s%s", p, tpre);
			if (strcmp(p, pre) == SAME)
				break;
			tpre[0] = '\0';
		}
		fclose(fn);
	}

	strcpy(out, tpre);
	strcat(out, npart);
	return;
}

	/*  file descriptor for call unit  */
int Dnf = 0;

/***
 *	dialup(ph, flds)	dial remote machine
 *	char *ph;
 *	char *flds[];
 *
 *	return codes:
 *		file descriptor  -  succeeded
 *		FAIL  -  failed
 */

dialup(ph, flds)
char *ph;
char *flds[];
{

#ifdef TNIX_DIAL
	struct Devices dev;
	char dcname[22];
	int dcr;
	FILE *dfp;
	int status;
	int ppid;
	char bfr[BUFSIZ];

	dfp = fopen(DEVFILE, "r");
	ASSERT(dfp != NULL, "CAN'T OPEN", DEVFILE, 0);
	if (setjmp(Sjbuf)) {
		fclose(dfp);
		DEBUG(1, "dialup: tty open timed out\n", "");
		sprintf(bfr, "call to %s", flds[F_NAME]);
		logent("TIMEOUT", bfr);
		delock(dev.D_line);
		return(FAIL);
	}
	signal(SIGALRM, alarmtr);
	while ((status = rddev(dfp, &dev)) != FAIL) {
		if (strcmp(flds[F_CLASS], dev.D_class) != SAME)
			continue;
		if (strcmp(flds[F_LINE], dev.D_type) != SAME)
			continue;
		if (mlock(dev.D_line) == FAIL)
			continue;
		sprintf(dcname, "/dev/%s", dev.D_line);
		alarm(20);
		if ((dcr = open(dcname, 2)) >= 0) { /* read/write */
			break;
		}
		alarm(0);
		delock(dev.D_line);
	}
	fclose(dfp);
	if (status == FAIL) {
		logent("DEVICE", "NO");
		DEBUG(4, "NO DEVICE %s", "");
		return(FAIL);
	}

	DEBUG(4, "dialup: dc - %s, ", dcname);
	DEBUG(4, "dn - %s\n",  dev.D_calldev);

	if (setjmp(Sjbuf)) {
		DEBUG(1, "dialup(): call to uuphone timed out\n", "");
		sprintf(bfr, "call to %s", flds[F_NAME]);
		logent("DIAL TIMEOUT", bfr);
		kill(ppid, SIGTERM);
		delock(dev.D_line);
		return(FAIL);
	}
	signal(SIGALRM, alarmtr);
	alarm(DIALTIME);
	fixline(dcr, dev.D_speed);
	DEBUG(5, "dialup(): calling '%s'\n", DIALPATH);
	if ((ppid=fork()) == 0) {
#define STDIN 0
#define	STDOUT 1
		dup2(dcr, STDOUT);
		dup2(dcr, STDIN);
		if (Debug > 0) {
			sprintf(bfr, "-x%d", Debug);
			execl(DIALPATH, DIALNAME, bfr, flds[F_NAME],
				dev.D_calldev, dcname, flds[F_PHONE], 0);
		} else {
			execl(DIALPATH, DIALNAME, flds[F_NAME],
				dev.D_calldev, dcname, flds[F_PHONE], 0);
		}
		exit(-1);
	}
	wait(&status);
	alarm(0);
	if (status != 0) {
		sprintf(bfr, "call to %s", flds[F_NAME]);
		logent("DIAL FAILED", bfr);
		DEBUG(4, "dialup(): DIAL FAILED, CODE %d\n", status);
		dcr = -1;
		return(FAIL);
	}

	fixline(dcr, dev.D_speed);
	return(dcr);

#else		/* NOT TNIX_DIAL */

#ifdef DIALOUT
	int dcf;
	if ((dcf = dialout(ph, flds[F_CLASS])) < 0)
		return(FAIL);
	return(dcf);

#else /* NOT DIALOUT */

	char dcname[20], dnname[20], phone[MAXPH+2];
	struct Devices dev;
#ifdef UCB
	struct sgttyb ttbuf;
#else
	struct termio ttbuf;
#endif
	int status;
	int nw, lt, pid, dcf;
	unsigned timelim;
	FILE *dfp;

	dfp = fopen(DEVFILE, "r");
	ASSERT(dfp != NULL, "CAN'T OPEN", DEVFILE, 0);
	while ((status = rddev(dfp, &dev)) != FAIL) {
		if (strcmp(flds[F_CLASS], dev.D_class) != SAME)
			continue;
		if (strcmp(flds[F_LINE], dev.D_type) != SAME)
			continue;
		if (mlock(dev.D_line) == FAIL)
			continue;
		sprintf(dnname, "/dev/%s", dev.D_calldev);
		sprintf(dcname, "/dev/%s", dev.D_line);
		if ((Dnf = open(dnname, 1)) > 0)
			break;
		delock(dev.D_line);
	}
	fclose(dfp);
	if (status == FAIL) {
		logent("DEVICE", "NO");
		DEBUG(4, "NO DEVICE %s", "");
		return(FAIL);
	}

	sprintf(phone, "%s%s", ph, ACULAST);
	DEBUG(4, "dc - %s, ", dcname);
	DEBUG(4, "acu - %s\n", dnname);
	if (setjmp(Sjbuf)) {
		DEBUG(1, "DN write %s\n", "timeout");
		logent("DIALUP DN write", "TIMEOUT");
		delock(dev.D_line);
		close(Dnf);
		return(FAIL);
	}
	signal(SIGALRM, alarmtr);
	timelim = 5 * strlen(phone);
	alarm(timelim < 30 ? 30 : timelim);
	pid = open(dcname, O_RDWR | O_NDELAY);
	nw = write(Dnf, phone, lt = strlen(phone));
	if (nw != lt) {
		DEBUG(1, "ACU write %s\n", "error");
		logent("DIALUP ACU write", "FAILED");
		alarm(0);
		close(Dnf);
		close(pid);
		return(FAIL);
	}
	else DEBUG(4, "ACU write ok%s\n", "");

	dcf = open(dcname, 2);
	close(pid);
	DEBUG(4, "dcf is %d\n", dcf);
	if (dcf < 0) {
		DEBUG(1, "Line open %s\n", "failed");
		logent("DIALUP LINE open", "FAILED");
		alarm(0);
		close(Dnf);
		delock(dev.D_line);
		return(FAIL);
	}
/*
 * Make sure hangup mode is set
 */

#ifdef UCB	
	ioctl(dcf, TIOCHPCL, 0);
#else
	ioctl(dcf, TCGETA, &ttbuf);
	if(!(ttbuf.c_cflag & HUPCL)) {
		ttbuf.c_cflag |= HUPCL;
		ioctl(dcf, TCSETA, &ttbuf);
	}
#endif
	alarm(0);
	fflush(stdout);
	fixline(dcf, dev.D_speed);
	return(dcf);

#endif	/* DIALOUT */

#endif /* TNIX_DIAL */
}

/***
 *	rddev - read and decode a line from device file
 *
 *	return code - FAIL at end-of file; 0 otherwise
 */

rddev(fp, dev)
struct Devices *dev;
FILE *fp;
{
	char *fdig();
	char buf[BUFSIZ];
	int na;

	if (!fgets(buf, BUFSIZ, fp))
		return(FAIL);

	na = sscanf(buf, "%s%s%s%s", dev->D_type, dev->D_line,
	  dev->D_calldev, dev->D_class);
	ASSERT(na >= 4, "BAD LINE", buf, 0);
	dev->D_speed = atoi(fdig(dev->D_class));
	return(0);
}

/***
 *	clsacu()	close call unit
 *
 *	return codes:  none
 */


clsacu()
{
#ifdef  TEK_UNET
#undef  ioctl
	if (use_unet > 0)
		ioctl(use_unet,UIOCCLOSE,0);
#define ioctl   Uioctl
#endif
	if (Dnf > 0) {
		close(Dnf);
		sleep(5);
		Dnf = 0;
	}
	return;
}


/***
 *	direct(flds)	connect to hardware line
 *	char *flds[];
 *
 *	return codes:
 *		>0  -  file number  -  ok
 *		FAIL  -  failed
 */

direct(flds)
char *flds[];
{
	int dcr, status;
	struct Devices dev;
	char dcname[20];
	FILE *dfp;

	dfp = fopen(DEVFILE, "r");
	ASSERT(dfp != NULL, "CAN'T OPEN", DEVFILE, 0);
	while ((status = rddev(dfp, &dev)) != FAIL) {
		if (strcmp(flds[F_CLASS], dev.D_class) != SAME)
			continue;
		if (strcmp(flds[F_LINE], dev.D_line) != SAME)
			continue;
#ifdef TNIX_HSI
		if ((strcmp(flds[F_PHONE], "hsi") == SAME) ||
			(strcmp(flds[F_PHONE], "HSI") == SAME)) {
			DEBUG(4, "direct(): using HSI %s\n", dev.D_line);
			Pkdrvon = 1;
		}
#endif /* TNIX */
		if (mlock(dev.D_line) != FAIL)
			break;
	}
	fclose(dfp);
	if (status == FAIL) {
		logent("DEVICE", "NO");
		DEBUG(4, "NO DEVICE %s", "");
		return(FAIL);
	}

	sprintf(dcname, "/dev/%s", dev.D_line);
	signal(SIGALRM, alarmtr);
	alarm(10);
	if (setjmp(Sjbuf)) {
		delock(dev.D_line);
		return(FAIL);
	}
	dcr = open(dcname, 2); /* read/write */
	alarm(0);
	if (dcr < 0) {
		delock(dev.D_line);
		return(FAIL);
	}
	fflush(stdout);
	fixline(dcr, dev.D_speed);
	return(dcr);
}

#ifdef DATAKIT

#define DKTRIES 2

/***
 *	dkcall(flds)	make datakit connection
 *
 *	return codes:
 *		>0 - file number - ok
 *		FAIL - failed
 */

dkcall(flds)
char *flds[];
{
	int dkphone;
	register char *cp;
	register ret, i;

	if (setjmp(Sjbuf))
		return(FAIL);
	signal(SIGALRM, alarmtr);
	dkphone = 0;
	cp = flds[F_PHONE];
	while(*cp)
		dkphone = 10 * dkphone + (*cp++ - '0');
	DEBUG(4, "dkphone (%d) ", dkphone);
	for (i = 0; i < DKTRIES; i++) {
		ret = dkdial(D_SH, dkphone, 0);
		DEBUG(4, "dkdial (%d)\n", ret);
		if (ret > -1)
			break;
	}
	return(ret);
}
#endif

#define MAXC 300

/***
 *	finds(fsys, sysnam, flds)	set system attribute vector
 *
 *	return codes:
 *		>0  -  number of arguments in vector - succeeded
 *		CF_SYSTEM  -  system name not found
 *		CF_TIME  -  wrong time to call
 */

finds(fsys, sysnam, flds)
char *sysnam, *flds[];
FILE *fsys;
{
	static char info[MAXC];
	char sysn[8];
	int na;
	int fcode = 0;

	/* format of fields
	 *	0 name;
	 *	1 time
	 *	2 acu/hardwired
	 *	3 speed
	 *	etc
	 */
	while (fgets(info, MAXC, fsys) != NULL) {
		na = getargs(info, flds);
		sprintf(sysn, "%.7s", flds[F_NAME]);
DEBUG(4,"comparing sysnam %s\n",sysnam);
DEBUG(4,"	with sysn %s\n",sysn);
		if (strcmp(sysnam, sysn) != SAME)
			continue;
		if (ifdate(flds[F_TIME]))
			/*  found a good entry  */
			return(na);
		logent(sysnam, "WRONG TIME TO CALL");
		fcode = CF_TIME;
	}
	return(fcode ? fcode : CF_SYSTEM);
}

/***
 *	login(nf, flds, dcr)		do log conversation
 *	char *flds[];
 *	int nf;
 *
 *	return codes:  0  |  FAIL
 */

login(nf, flds, fn)
char *flds[];
int nf, fn;
{
	char *want, *altern;
	extern char *index();
	int k, ok;

	ASSERT(nf > 4, "TOO FEW LOG FIELDS", "", nf);
#ifdef TNIX_ENHANCE
	DEBUG(4, "login('%s'):\n", flds[F_LOGIN]);
#endif
	for (k = F_LOGIN; k < nf; k += 2) {
		want = flds[k];
		ok = FAIL;
		while (ok != 0) {
			altern = index(want, '-');

			if (altern != NULL)
				*altern++ = '\0';
#ifdef TNIX_ENHANCE
			if (*want == '\0') {
				DEBUG(5, "login: no initial expect\n", "");
				goto send;
			}
#endif
			ok = expect(want, fn);
			if (ok == 0)
				break;
			if (altern == NULL) {
				logent("LOGIN", "FAILED");
#ifdef TNIX_BUGFIX
				close(fn);
#endif
				return(FAIL);
			}
#ifdef TNIX_ENHANCE
		send:
#endif
			want = index(altern, '-');
			if (want != NULL)
				*want++ = '\0';
			sendthem(altern, fn);
		}
		sleep(2);
		sendthem(flds[k+1], fn);
	}
	return(0);
}


struct sg_spds {int sp_val, sp_name;} spds[] = {
	{ 300,  B300},
	{1200, B1200},
	{2400, B2400},
	{4800, B4800},
	{9600, B9600},
	{0, 0} };

/***
 *	fixline(tty, spwant)	set speed/echo/mode...
 *	int tty, spwant;
 *
 *	return codes:  none
 */

fixline(tty, spwant)
int tty, spwant;
{
#ifdef UCB
	struct sgttyb ttbuf;
#else
	struct termio ttbuf;
#endif
	struct sg_spds *ps;
	int speed = -1;
	int ret;

#ifdef TNIX_ENHANCE
	DEBUG(4, "fixline(%d)\n", spwant);
#endif
	for (ps = spds; ps->sp_val; ps++)
		if (ps->sp_val == spwant)
			speed = ps->sp_name;
	ASSERT(speed >= 0, "BAD SPEED", "", speed);
#ifdef TNIX
	ret = ioctl(tty, TIOCGETP, &ttbuf);
	ttbuf.sg_flags =(ONOCAR|RAW);
	ttbuf.sg_ispeed = ttbuf.sg_ospeed = speed;
	ret = ioctl(tty, TIOCSETP, &ttbuf);
	ASSERT(ret >= 0, "RETURN FROM STTY 1", "", ret);
	ret = ioctl(tty, TIOCFLUSH, &ttbuf);
	ASSERT(ret >= 0, "RETURN FROM STTY 2", "", ret);
	ret = ioctl(tty, TIOCHPCL, &ttbuf);
#ifdef TNIX_HSI
	if (Pkdrvon) {
		/*ret = ioctl(tty, TIOHMODE(??), &ttbuf);*/
	}
#endif
#else
#ifdef UCB
	ret = ioctl(tty, TIOCGETP, &ttbuf);
	ttbuf.sg_flags =(ANYP|RAW);
	ttbuf.sg_ispeed = ttbuf.sg_ospeed = speed;
	ret = ioctl(tty, TIOCSETP, &ttbuf);
#else
	ioctl(tty, TCGETA, &ttbuf);
	ttbuf.c_iflag = (unsigned short)0;
	ttbuf.c_oflag = (unsigned short)0;
	ttbuf.c_cflag = (speed|CS8|HUPCL|CREAD);
	ttbuf.c_lflag = (unsigned short)0;
	ttbuf.c_cc[VMIN] = 6;
	ttbuf.c_cc[VTIME] = 1;
	ret = ioctl(tty, TCSETA, &ttbuf);
#endif /* UCB */
#endif /* TNIX */
	ASSERT(ret >= 0, "RETURN FROM STTY", "", ret);
	return;
}


#define MR 300


/***
 *	expect(str, fn)	look for expected string
 *	char *str;
 *
 *	return codes:
 *		0  -  found
 *		FAIL  -  lost line or too many characters read
 *		some character  -  timed out
 */

expect(str, fn)
char *str;
int fn;
{
	static char rdvec[MR];
	char *rp = rdvec;
	int kr;
	char nextch;

#ifdef TNIX_ENHANCE
	DEBUG(4, "expect('%s')\n", str);
#endif
	if (strcmp(str, "\"\"") == SAME)
		return(0);
	*rp = 0;
	if (setjmp(Sjbuf)) {
		return(FAIL);
	}
	signal(SIGALRM, alarmtr);
	while (notin(str, rdvec)) {
		alarm(MAXCHARTIME);
		kr = read(fn, &nextch, 1);
		if (kr <= 0) {
			alarm(0);
			DEBUG(4, "lost line kr - %d\n, ", kr);
			logent("LOGIN", "LOST LINE");
			return(FAIL);
		}
#ifdef TNIX_ENHANCE
		{
		int c;
		c = nextch & 0177;
		DEBUG(9, "%c", (c >= 040) && (c != 0177) ? c : '_');
		}
#endif
		if ((*rp = nextch & 0177) != '\0')
			rp++;
#ifndef TNIX_BUGFIX
		*rp = '\0';
#endif
		if (rp >= rdvec + MR) {
			alarm(0);
			return(FAIL);
		}
#ifdef TNIX_BUGFIX
		*rp = '\0';	/* Lou Salkind's fix of 3/38/82 */
#endif
	}
	alarm(0);
	return(0);
}


/***
 *	alarmtr()  -  catch alarm routine for "expect".
 */

alarmtr()
{
	DEBUG(6, "alarmtr: CAUGHT ALARM from expect\n", "");
	longjmp(Sjbuf, 1);
}


/***
 *	sendthem(str, fn)	send line of login sequence
 *	char *str;
 *
 *	return codes:  none
 */

	
sendthem(str, fn)
char *str;
int fn;
{
	int nw, ns;
	int nulls;

#ifdef TNIX_ENHANCE
	int nlw = 1;
	char *strptr;

	DEBUG(5, "sendthem('%s')\n", str);
#endif
	if (prefix("BREAK", str)) {
		sscanf(&str[5], "%1d", &nulls);
		if (nulls <= 0 || nulls > 10)
			nulls = 3;
		/* send break */
		genbrk(fn, nulls);
		return;
	}

	if (strcmp(str, "EOT") == SAME) {
		write(fn, EOTMSG, strlen(EOTMSG));
		return;
	}
#ifdef TNIX_ENHANCE
	for (strptr = str; *strptr; strptr++) {
		if (*strptr == '\\') {
			switch(*++strptr) {
			case 's':	/* space */
				DEBUG(5, "send: space\n", "");
				*strptr = ' ';
				break;
			case 'd':	/* delay */
				DEBUG(5, "send: delay\n", "");
				sleep(1);
				continue;
			case 'r':	/* return */
				DEBUG(5, "send: return\n", "");
				*strptr = '\r';
				break;
			case 'b':	/* break */
				if (isdigit(*(strptr+1))) {
					nulls = (*++strptr - '0');
					if (nulls <= 0 || nulls > 10)
						nulls = 3;
				} else
					nulls = 3;

				/* send break */
				DEBUG(5, "send: break (%d nulls)\n", nulls);

				genbrk(fn, nulls);
				continue;
			case 'c':	/* no NL */
				if (*(strptr+1) == '\0') {
					DEBUG(5, "send: no newline\n", "");
					nlw = 0;
				}
				continue;
			default:
				DEBUG(5, "send: backslash\n", "");
				strptr--;
			}
		}
		nw = write(fn, strptr, 1);
		if (nw != 1) {
			DEBUG(4, "send: WRITE ERROR got %d\n", nw);
		}
		ASSERT(nw == 1, "BAD WRITE %s", str, 0);
	}
	if (nlw) write(fn, "\n", 1);
#else	/* not TNIX */

	if (strcmp(str, "") != SAME) {
		nw = write(fn, str, ns = strlen(str));
		ASSERT(nw == ns, "BAD WRITE", str, 0);
	}
	write(fn, "\n", 1);
#endif /* TNIX */
	return;
}

#ifdef TNIX
#define	BSPEED B300
#else
#define BSPEED B150
#endif

/***
 *	genbrk		send a break
 *
 *	return codes;  none
 */

genbrk(fn, bnulls)
{
#ifndef TNIX
#ifdef UCB
	ioctl(fn, TIOCSBRK, 0);
	sleep(2);
	ioctl(fn, TIOCCBRK, 0);
#else
	ioctl(fn, TCSBRK, 0);
#endif
#else
	struct sgttyb ttbuf;
	int ret, sospeed;

	ret = ioctl(fn, TIOCGETP, &ttbuf);
	DEBUG(5, "genbrk: ioctl ret %d\n", ret);
	sospeed = ttbuf.sg_ospeed;
	ttbuf.sg_ospeed = BSPEED;
	ret = ioctl(fn, TIOCSETP, &ttbuf);
	DEBUG(5, "genbrk: ioctl ret %d\n", ret);
	ret = write(fn, "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0", bnulls);
	ASSERT(ret > 0, "BAD WRITE genbrk", "", ret);
	ttbuf.sg_ospeed = sospeed;
	ret = ioctl(fn, TIOCSETP, &ttbuf);
	ret = write(fn, "@", 1);
	ASSERT(ret > 0, "BAD WRITE genbrk", "", ret);
	DEBUG(4, "genbrk: sent BREAK nulls - %d\n", bnulls);
#endif
	return;
}


/***
 *	notin(sh, lg)	check for occurrence of substring "sh"
 *	char *sh, *lg;
 *
 *	return codes:
 *		0  -  found the string
 *		1  -  not in the string
 */

notin(sh, lg)
char *sh, *lg;
{
	while (*lg != '\0') {
		if (prefix(sh, lg))
			return(0);
		else
			lg++;
	}
	return(1);
}


/*******
 *	ifdate(s)
 *	char *s;
 *
 *	ifdate  -  this routine will check a string (s)
 *	like "MoTu0800-1730" to see if the present
 *	time is within the given limits.
 *	SIDE EFFECT - Retrytime is set
 *
 *	String alternatives:
 *		Wk - Mo thru Fr
 *		zero or one time means all day
 *		Any - any day
 *
 *	return codes:
 *		0  -  not within limits
 *		1  -  within limits
 */

ifdate(s)
char *s;
{
	static char *days[]={
		"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa", 0
	};
	long clock;
	int rtime;
	int i, tl, th, tn, flag, dayok=0;
	struct tm *localtime();
	struct tm *tp;
	char *index();
	char *p;

	/*  pick up retry time for failures  */
	/*  global variable Retrytime is set here  */
	if ((p = index(s, ',')) == NULL) {
		Retrytime = RETRYTIME;
	}
	else {
		i = sscanf(p+1, "%d", &rtime);
		if (i < 1 || rtime < 5)
			rtime = 5;
		Retrytime  = rtime * 60;
	}

	time(&clock);
	tp = localtime(&clock);
	while (isalpha(*s)) {
		for (i = 0; days[i]; i++) {
			if (prefix(days[i], s))
				if (tp->tm_wday == i)
					dayok = 1;
		}

		if (prefix("Wk", s))
			if (tp->tm_wday >= 1 && tp->tm_wday <= 5)
				dayok = 1;
		if (prefix("Any", s))
			dayok = 1;
		s++;
	}

	if (dayok == 0)
		return(0);
	i = sscanf(s, "%d-%d", &tl, &th);
	tn = tp->tm_hour * 100 + tp->tm_min;
	if (i < 2)
		return(1);
	if (th < tl)
		flag = 0;  /* set up for crossover 2400 test */
	else
		flag = 1;
	if ((tn >= tl && tn <= th)
	  || (tn >= th && tn <= tl)) /* test for crossover 2400 */
		return(flag);
	else
		return(!flag);
}


/***
 *	char *
 *	lastc(s)	return pointer to last character
 *	char *s;
 *
 */

char *
lastc(s)
char *s;
{
	while (*s != '\0') s++;
	return(s);
}



/***
 *	char *
 *	fdig(cp)	find first digit in string
 *
 *	return - pointer to first digit in string or end of string
 */

char *
fdig(cp)
char *cp;
{
	char *c;

	for (c = cp; *c; c++)
		if (*c >= '0' && *c <= '9')
			break;
	return(c);
}

#if  TEK_UNET || TEK_4_1A
/*
 *      Don't allow ioctl's to go out to UNET lines
 */
#undef  ioctl
int Uioctl(fd,comm,buf)
{
	if (use_unet > 0)
		return(0);
	return(ioctl(fd,comm,buf));
};      /* end of Uioctl */

/*
 *      special version of isatty.c that rejects UNET lines
 */
int isatty(fd)
{
	struct sgttyb ttyb;

	if ((use_unet > 0) && (fd == use_unet))
		return(0);
	if (gtty(fd,&ttyb) < 0)
		return(0);
	return(1);
};      /* end of isatty */
#endif
