/*
 * Tektronix 8560 Unix - Unix Copy
 *
 *	Based on Western Electric System III Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */


#ifdef SCCSID
static char *sccsid = "@(#)@(#)cico.c	5.1 (82/12/08) Tektronix 8560 Unix";
#endif

	/*  cico 3.7  1/5/80  16:32:57  */
#include "uucp.h"
#include <signal.h>
#include <setjmp.h>
#include <sys/types.h>
#ifdef UCB
#include <sgtty.h>
#else
#include <termio.h>
#endif
#include "uust.h"
#include "uusub.h"

#if TEK_UNET || TEK_4_1A
#define TEK_
#endif

#if TEK_UNET && TEK_4_1A
ERROR!!
#endif

#ifdef TEK_
#define ioctl   Uioctl
int     use_unet;
#endif

#ifdef  TEK_UNET
#include <unetconfig.h>
#include <unetio.h>
#include <tcp.h>
int     unet_lport;
#endif

/*char Scico[] = "@(#)cico	3,7";*/

jmp_buf Sjbuf;
	/*  call fail text  */
char *Stattext[] = {
	"",
	"BAD SYSTEM",
	"WRONG TIME",
	"SYSTEM LOCKED",
	"NO DEVICE",
	"DIAL FAILED",
	"LOGIN FAILED",
	"BAD SEQUENCE"
	};

int Role = 0;
char *ttyname();

	/*  call fail codes  */
int Stattype[] = {0, 0, 0, 0,
	SS_NODEVICE, SS_FAIL, SS_FAIL, SS_BADSEQ
	};


int Errorrate = 0;
#ifdef UCB
struct sgttyb Savettyb;
#else
struct termio Savettyb;
#endif

/*******
 *	cico - this program is used  to place a call to a
 *	remote machine, login, and copy files between the two machines.
 */

main(argc, argv)
char *argv[];
{
	int ret, seq;
	int onesys = 0;
	char wkpre[NAMESIZE], file[NAMESIZE];
	char msg[BUFSIZ], *p, *q;
	extern onintr(), timeout();
	extern intrEXIT();
	extern char *pskip();
	char rflags[30];
	char *ttyn;

#ifdef TNIX_HSI
	char *ptr;
	char hsi_name[15];
#endif

	strcpy(Progname, "uucico");
	signal(SIGILL, intrEXIT);
	signal(SIGTRAP, intrEXIT);
	signal(SIGIOT, intrEXIT);
	signal(SIGEMT, intrEXIT);
	signal(SIGFPE, intrEXIT);
	signal(SIGBUS, intrEXIT);
	signal(SIGSEGV, intrEXIT);
	signal(SIGSYS, intrEXIT);
	signal(SIGINT, onintr);
	signal(SIGHUP, onintr);
	signal(SIGQUIT, onintr);
	signal(SIGTERM, onintr);
#ifdef TEK_4_1A
	signal(SIGPIPE, intrEXIT);
#endif

	ret = guinfo(getuid(), User, msg);
	strcpy(Loginuser, User);
	ASSERT(ret == 0, "BAD UID ", "", ret);

	rflags[0] = '\0';
	uucpname(Myname);
	umask(WFMASK);
	strcpy(Rmtname, Myname);
	Ifn = Ofn = -1;
	while(argc>1 && argv[1][0] == '-'){
		switch(argv[1][1]){
		case 'd':
			Spool = &argv[1][2];
			break;
#ifdef  TEK_4_1A
		case 'v':
			use_unet = 1;
			break;
#endif
#ifdef  TEK_UNET
		case 'u':
			unet_lport = atoi(&argv[1][2]);
			use_unet = 
				tcpopen((char *)0,0,unet_lport,TO_PASSIVE,"rw");
			ASSERT(use_unet > 0,
				"Can't make connection %d", "",use_unet);
			Ifn = Ofn = use_unet;
			break;
#endif
#ifdef PROTODEBUG
		case 'E':
			Errorrate = atoi(&argv[1][2]);
			if (Errorrate <= 0)
				Errorrate = 100;
			break;
		case 'g':
			Pkdrvon = 1;
			break;
		case 'G':
			Pkdrvon = 1;
			strcat(rflags, " -g ");
			break;
#endif
		case 'r':
			Role = atoi(&argv[1][2]);
			break;
		case 's':
			sprintf(Rmtname, "%.7s", &argv[1][2]);
			if (Rmtname[0] != '\0')
				onesys = 1;
			break;
		case 'x':
			Debug = atoi(&argv[1][2]);
			if (Debug <= 0)
				Debug = 1;
			strcat(rflags, argv[1]);
			break;
		default:
			printf("unknown flag %s\n", argv[1]);
			break;
		}
		--argc;  argv++;
	}

	chdir(Spool);
	strcpy(Wrkdir, Spool);

	if (Role == SLAVE) {
		/* initial handshake */
		onesys = 1;
/*
 *		System 3 terminal driver
 *
 *		ret = ioctl(0, TCGETA, &Savettyb);
 *		Savettyb.c_cflag = (Savettyb.c_cflag & ~CS8) | CS7;
 *		Savettyb.c_oflag |= OPOST;
 *		Savettyb.c_lflag |= (ISIG|ICANON|ECHO);
 */
#ifndef TEK_
		ret = ioctl(0, TIOCGETP, &Savettyb);
#else
		if (Ifn < 0)
		{
			Ifn = 0;
			Ofn = 1;
		}
		ret = ioctl(Ifn, TIOCGETP, &Savettyb);
#endif
		Savettyb.sg_flags |= ECHO;
		Savettyb.sg_flags &= ~RAW;
#ifndef TEK_
		Ifn = 0;
		Ofn = 1;
#endif
		fixmode(Ifn);
#ifdef TNIX_ENHANCE
		freopen(RMTDEBUG, "w", stderr);

		/*
		 * it is not understood how the code below is supposed
		 * to work - mcg
		 */
#else
		fclose(stderr);
		fopen(RMTDEBUG, "w");
#endif
		chmod(RMTDEBUG, 0666);
		omsg('S', "here", Ofn);
		signal(SIGALRM, timeout);
		alarm(MAXMSGTIME);
		if (setjmp(Sjbuf)) {
			/* timed out */
/*
 *			System 3 terminal handler
 *
 *
 *			ret = ioctl(0, TCSETA, &Savettyb);
 */

#ifndef TEK_
			ret = ioctl(0, TIOCSETP, &Savettyb);
#else
			ret = ioctl(Ifn, TIOCSETP, &Savettyb);
#endif
			exit(0);
		}
		for (;;) {
			ret = imsg(msg, Ifn);
			if (ret != 0) {
				alarm(0);
/*
 *				System 3 terminal handler calls
 *
 *				ret = ioctl(0, TCSETA, &Savettyb);
 */

#ifndef TEK_
				ret = ioctl(0, TIOCSETP, &Savettyb);
#else
				ret = ioctl(Ifn, TIOCSETP, &Savettyb);
#endif
				exit(0);
			}
			if (msg[0] == 'S')
				break;
		}
		alarm(0);
		DEBUG(4, "msg-%s,", msg);
		q = &msg[1];
		p = pskip(q);
		sprintf(Rmtname, "%.7s", q);
		DEBUG(4, "sys-%s\n", Rmtname);
		if (mlock(Rmtname)) {
			omsg('R', "LCK", Ofn);
			cleanup(0);
		}
		else if (callback(Loginuser)) {
			signal(SIGINT, SIG_IGN);
			signal(SIGHUP, SIG_IGN);
			omsg('R', "CB", Ofn);
			logent("CALLBACK", "REQUIRED");
			/*  set up for call back  */
			systat(Rmtname, SS_CALLBACK, "CALL BACK");
			gename(CMDPRE, Rmtname, 'C', file);
			close(creat(file, 0666));
			chmod(file, 0666);
			xuucico(Rmtname);
			cleanup(0);
		}
		seq = 0;
		while (*p == '-') {
			q = pskip(p);
			switch(*(++p)) {
			case 'g':
				Pkdrvon = 1;
				break;
			case 'x':
				Debug = atoi(++p);
				if (Debug <= 0)
					Debug = 1;
				break;
			case 'Q':
				seq = atoi(++p);
				break;
			default:
				break;
			}
			p = q;
		}
		if (callok(Rmtname) == SS_BADSEQ) {
			logent("BADSEQ", "PREVIOUS");
			omsg('R', "BADSEQ", Ofn);
			cleanup(0);
		}
		if ((ret = gnxseq(Rmtname)) == seq) {
			omsg('R', "OK", Ofn);
			cmtseq();
		}
		else {
			systat(Rmtname, Stattype[7], Stattext[7]);
			logent("BAD SEQ", "HANDSHAKE FAILED");
			ulkseq();
			omsg('R', "BADSEQ", Ofn);
			cleanup(0);
		}
#ifndef TNIX
#ifdef MDP
		strcpy(Rmtalias, p);
		p = pskip(p);
		DEBUG(4, "alias-%s\n", Rmtalias);
#endif	
#endif
	}
loop:
	if (!onesys) {
		ret = gnsys(Rmtname, Spool, CMDPRE);
		if (ret == FAIL)
			cleanup(100);
		if (ret == 0)
			cleanup(0);
	}
	else if (Role == MASTER && callok(Rmtname) != 0) {
		logent("SYSTEM STATUS", "CAN NOT CALL");
		cleanup(0);
	}

#ifdef MDP
	sprintf(wkpre, "%c.", CMDPRE);
#else
	sprintf(wkpre, "%c.%.7s", CMDPRE, Rmtname);
#endif

	if (Role == MASTER) {
		/*  master part */
		signal(SIGINT, SIG_IGN);
		signal(SIGHUP, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		if (!iswrk(file, "chk", Spool, wkpre) && !onesys) {
			logent(Rmtname, "NO WORK");
			goto next;
		}
		if (Ifn != -1 && Role == MASTER) {
			write(Ofn, EOTMSG, strlen(EOTMSG));
			close(Ofn);
			close(Ifn);
			Ifn = Ofn = -1;
			rmlock(CNULL);
			clsacu();
			sleep(3);
		}
		sprintf(msg, "call to %s ", Rmtname);
		if (mlock(Rmtname) != 0) {
			logent(msg, "LOCKED");
			US_SST(us_s_lock);
			goto next;
		}
		Ofn = Ifn = conn(Rmtname);
DEBUG(4,"OFn from connect call %d \n",Ofn);
		if (Ofn < 0) {
			logent(msg, "FAILED");
			US_SST(-Ofn);
			UB_SST(-Ofn);
			systat(Rmtname, Stattype[-Ofn],
				Stattext[-Ofn]);
			goto next;
		}
		else {
			logent(msg, "SUCCEEDED");
DEBUG(4," Going to USSST\n",0);
			US_SST(us_s_cok);
DEBUG(4," Going to UBSST\n",0);
			UB_SST(ub_ok);
		}
	
		if (setjmp(Sjbuf))
			goto next;
		signal(SIGALRM, timeout);
		alarm(2 * MAXMSGTIME);
		for (;;) {
			ret = imsg(msg, Ifn);
			if (ret != 0) {
				alarm(0);
				goto next;
			}
			if (msg[0] == 'S')
				break;
		}
		alarm(MAXMSGTIME);
DEBUG(4,"Going to gnxseq for %s\n",Rmtname);
		seq = gnxseq(Rmtname);
#ifdef TNIX_HSI
		/*
		 * Using Chet's version of the HSI support code:
		 * this '-g' flag is used to turn Pkdrvon, which
		 * disables the packet driver. this is actually
		 * a debugging option from the original, but I
		 * am temporarily using it here, until I can be sure
		 * that the protocol selection code works.
		 */

		if (Pkdrvon) {
			if (rflags[0] == '\0') strcat(rflags, "-g ");
			else strcat(rflags, " -g ");
		}
#endif /* TNIX */
#ifdef TNIX_ENHANCE
		sprintf(msg, "%.7s -Q%d %s", Myname, seq, rflags);
#else
#ifdef MDP
/* BUG */	sprintf(msg, "%.7s -Q%d %s Myalias", Myname,seq,rflags,Myalias);
#else
		sprintf(msg, "%.7s -Q%d %s", Myname, seq, rflags);
#endif
#endif
		omsg('S', msg, Ofn);
		for (;;) {
			ret = imsg(msg, Ifn);
			DEBUG(4, "msg-%s\n", msg);
			if (ret != 0) {
				alarm(0);
				ulkseq();
				goto next;
			}
			if (msg[0] == 'R')
				break;
		}
		alarm(0);
		if (msg[1] == 'B') {
			/* bad sequence */
			logent("BAD SEQ", "HANDSHAKE FAILED");
			US_SST(us_s_hand);
			systat(Rmtname, Stattype[7], Stattext[7]);
			ulkseq();
			goto next;
		}
		if (strcmp(&msg[1], "OK") != SAME)  {
			logent(&msg[1], "HANDSHAKE FAILED");
			US_SST(us_s_hand);
			ulkseq();
			goto next;
		}
		cmtseq();
	}
	ttyn = ttyname(Ifn);
	if (ttyn != NULL)
		chmod(ttyn, 0600);
	DEBUG(1, " Rmtname %s, ", Rmtname);
	DEBUG(1, "Role %s,  ", Role ? "MASTER" : "SLAVE");
	DEBUG(1, "Ifn - %d, ", Ifn);
	DEBUG(1, "Loginuser - %s\n", Loginuser);

	ret = startup(Role);
	if (ret != SUCCESS) {
		logent("startup", "FAILED");
		US_SST(us_s_start);
		systat(Rmtname, SS_FAIL, "STARTUP");
		goto next;
	}
	else {
#ifdef TNIX_HSI
#define	HSIDEV	"/dev/hsix"


		/*
		 * special code for HSI - until we get protocol selection
		 * working correctly
		 */

		if (Pkdrvon) {

			ptr = ttyn;
			while (*ptr++);
			ptr -= 2;	/* get tty number */
			DEBUG(4, "HSI: tty # was %s\n", ttyn);
			strcpy(hsi_name, HSIDEV);
			strcat(hsi_name, ptr);
			DEBUG(1, "HSI: opening %s\n", hsi_name);
			close(Ifn);	/* old tty stdin */
			close(Ofn);	/* old stdout */
			Ofn = Ifn = open(hsi_name, 2);
			if (Ofn < 0) {
				logent("HSI", "FAILED");
				systat(Rmtname, Stattype[-Ofn], Stattext[-Ofn]);
				goto next;
			}
			logent("HSI startup", "OK");
		}
#endif /* TNIX */

		logent("startup", "OK");
		US_SST(us_s_gress);
		systat(Rmtname, SS_INPROGRESS, "TALKING");
		ret = cntrl(Role, wkpre);
		DEBUG(1, "cntrl - %d\n", ret);
		signal(SIGINT, SIG_IGN);
		signal(SIGHUP, SIG_IGN);
		signal(SIGALRM, timeout);
		if (ret == 0) {
			logent("conversation complete", "OK");
			US_SST(us_s_ok);
			rmstat(Rmtname);

		}
		else {
			logent("conversation complete", "FAILED");
			US_SST(us_s_cf);
			systat(Rmtname, SS_FAIL, "CONVERSATION");
		}
#ifdef TNIX_HSI
		if (Pkdrvon) {
			DEBUG(1, "HSI: hsi to %s complete\n", Rmtname);
			Pkdrvon = 0;
			close(Ifn);
			close(Ofn);
			Ifn = Ofn = -1;
			goto next;
		}
#endif /* TNIX */

		alarm(MAXMSGTIME);
#ifdef TEK_4_1A
		if (!use_unet) {
			omsg('O', "OOOOO", Ofn);
		}
#else
		omsg('O', "OOOOO", Ofn);
#endif
		DEBUG(4, "send OO %d,", ret);
		if (!setjmp(Sjbuf)) {
			for (;;) {
				omsg('O', "OOOOO", Ofn);
				ret = imsg(msg, Ifn);
				if (ret != 0)
					break;
				if (msg[0] == 'O')
					break;
			}
		}
		alarm(0);
	}
next:
	if (!onesys) {
		goto loop;
	}
	cleanup(0);
}

/***
 *	cleanup(code)	cleanup and exit with "code" status
 *	int code;
 */

short Hupvec[] = {0, 0, 1};

cleanup(code)
int code;
{
	int ret;
	char *ttyn;

	signal(SIGINT, SIG_IGN);
	signal(SIGHUP, SIG_IGN);
	rmlock(CNULL);
	clsacu();
	logcls();
	if (Role == SLAVE) {

/*
 *		Savettyb.c_cflag |= HUPCL;
 *		ret = ioctl(0, TCSETA, &Savettyb);
 */

#ifndef TEK_
		ret = ioctl(0, TIOCSETP, &Savettyb);
#else
		ret = ioctl(Ifn, TIOCSETP, &Savettyb);
#endif
		DEBUG(4, "\nIfn - %d, ", Ifn);
		DEBUG(4, "ret ioctl - %d\n", ret);
		DEBUG(4, "tty.flags %o,", Savettyb.sg_flags);
		DEBUG(4, "tty.ispeed %d, ", Savettyb.sg_ispeed);
		DEBUG(4, "tty.ospeed %d, ", Savettyb.sg_ospeed);
#ifndef TEK_
		ret = ioctl(0, TIOCSETP, Hupvec);
#else
		ret = ioctl(Ifn, TIOCSETP, Hupvec);
#endif
		DEBUG(4, "ret ioctl - %d\n", ret);
#ifdef TNIX_ENHANCE
		fflush(stderr);	/* flush output to the audit file */
#endif
	}
	if (Ofn != -1) {
#ifdef TEK_4_1A
		if ((Role == MASTER) && (!use_unet)) {
#else
		if (Role == MASTER) {
#endif
			write(Ofn, EOTMSG, strlen(EOTMSG));
		}
		ttyn = ttyname(Ifn);
		if (ttyn != NULL)
			chmod(ttyn, 0666);
		close(Ifn);
		close(Ofn);
	}
	DEBUG(1, "exit code %d\n", code);
	if (code == 0)
		xuuxqt();
	exit(code);
}

/***
 *	onintr(inter)	interrupt - remove locks and exit
 */

onintr(inter)
int inter;
{
	char str[30];
	signal(inter, SIG_IGN);
	sprintf(str, "SIGNAL %d", inter);
	logent(str, "CAUGHT");
	cleanup(inter);
}

#ifdef UCB
intrEXIT(signo)
int signo;
{
	signal(signo, SIG_DFL);
	setuid(getuid());
	abort();
}
#else
intrEXIT()
{
	signal(SIGIOT, SIG_DFL);
	signal(SIGILL, SIG_DFL);
	setuid(getuid());
	abort();
}
#endif

/***
 *	fixmode(tty)	fix kill/echo/raw on line
 *
 *	return codes:  none
 */

fixmode(tty)
int tty;
{
#ifdef UCB
	struct sgttyb ttbuf;
#else
	struct termio ttbuf;
#endif
	int ret;

#ifdef UCB
	ioctl(tty, TIOCGETP, &ttbuf);
	ttbuf.sg_flags = (ANYP | RAW);
	ret = ioctl(tty, TIOCSETP, &ttbuf);
	ioctl(tty, TIOCEXCL, 0);
#else
	ioctl(tty, TCGETA, &ttbuf);
	ttbuf.c_iflag = ttbuf.c_oflag = ttbuf.c_lflag = (unsigned short)0;
	ttbuf.c_cflag &= (CBAUD);
	ttbuf.c_cflag |= (CS8|CREAD);
	ttbuf.c_cc[VMIN] = 6;
	ttbuf.c_cc[VTIME] = 1;
	ret = ioctl(tty, TCSETA, &ttbuf);
#endif
	ASSERT(ret >= 0, "STTY FAILED", "", ret);
	return;
}


/***
 *	timeout()	catch SIGALRM routine
 */

timeout()
{
	longjmp(Sjbuf, 1);
}

static char *
pskip(p)
register char *p;
{
	while( *p && *p != ' ' )
		++p;
	if( *p ) *p++ = 0;
	return(p);
}
