FUNCTION MIN(* (A,B:INTEGER):INTEGER *);
BEGIN
  IF A<B THEN MIN:=A ELSE MIN:=B
END;

FUNCTION MAX (*(A,B:INTEGER):INTEGER*);
BEGIN
  IF A>B THEN MAX:=A ELSE MAX:=B
END;

FUNCTION GETCH(*:CHAR*);
VAR GCH: CHAR;
BEGIN
  READ(KEYBOARD,GCH);
  IF EOLN(KEYBOARD) THEN GCH:=CHR(EOL);
  GETCH:=GCH;
END;

FUNCTION MAPTOCOMMAND(* (CH:CHAR): COMMANDS *);
BEGIN
  IF (CH=SYSCOM^.CRTCTRL.ESCAPE) AND (CH<>CHR(0)) THEN
    BEGIN
      CH:=GETCH;
      IF CH=SYSCOM^.CRTINFO.LEFT THEN MAPTOCOMMAND:=LEFT
      ELSE
        IF CH=SYSCOM^.CRTINFO.RIGHT THEN MAPTOCOMMAND:=RIGHT
        ELSE
          IF CH=SYSCOM^.CRTINFO.UP THEN MAPTOCOMMAND:=UP
          ELSE
            IF CH=SYSCOM^.CRTINFO.DOWN THEN MAPTOCOMMAND:=DOWN
            ELSE
              MAPTOCOMMAND:=ILLEGAL
    END
  ELSE
    MAPTOCOMMAND:=TRANSLATE[CH];
END;

FUNCTION UCLC(*(CH:CHAR):CHAR*); (* Map Lower Case to Upper Case *)
BEGIN
  IF CH IN ['a'..'z'] THEN UCLC:=CHR(ORD(CH)-32) ELSE UCLC:=CH
END;

PROCEDURE CONTROL(*CH:CTYPE*);
(* Based on the parameter passed, use crtctrl to put out the
   appropriate control code for the host terminal *)
BEGIN
  WITH SYSCOM^.CRTCTRL DO
    BEGIN
      IF ESCAPE<>CHR(0) THEN WRITE(ESCAPE);
      CASE CH OF
        FS:     WRITE(NDFS);
        GOHOME: WRITE(HOME);
        ETOEOL: WRITE(ERASEEOL);
        ETOEOS: WRITE(ERASEEOS);
        US:     WRITE(RLF)
      END
    END
END;

PROCEDURE PUTMSG;
BEGIN
  CONTROL(GOHOME); CONTROL(ETOEOL);
  WRITE(MSG);
END;

PROCEDURE HOME; BEGIN CONTROL(GOHOME) END;

PROCEDURE ERASETOEOL; BEGIN CONTROL(ETOEOL) END;

PROCEDURE PROMPT;
BEGIN
  PROMPTLINE[1]:=DIRECTION;
  CONTROL(GOHOME); CONTROL(ETOEOL); WRITE(PROMPTLINE)
END;

PROCEDURE ERRWAIT;
BEGIN
  WRITE(CHR(BELL));
  PROMPT;
END;

PROCEDURE BLANKCRT(*Y: INTEGER*);
BEGIN
  GOTOXY(0,Y);
  CONTROL(ETOEOS);
END;

PROCEDURE ERROR(*S: STRING;HOWBAD: ERRORTYPE*);
BEGIN
  HOME; ERASETOEOL;
  UNITCLEAR(1); (* Throw away all characters queued up *)
  WRITE('ERROR: ',S);
  IF HOWBAD=FATAL THEN
    EXIT(EDITOR)
  ELSE
    BEGIN
      WRITE('  Please press <spacebar> to continue.');
      REPEAT UNTIL GETCH=' '; NEEDPROMPT:=TRUE
    END;
END;
