#include <stdio.h>
#include <rank.h>
#include <debug.h>
#include "usr.h"			/* usr switches */
#define ABS(x,y) (x)?(y * -1.0):(y)
#define HASHSTR(x) table[x].hkey
#define DATALIST(x) table[x].startlist

	/* some output fmt stuff */
#define FMTSIZ 32
char *header="\n\nWilcoxon Match pairs Test:'%s' and '%s'.\n";
char fmt[FMTSIZ];	/* used in printf after max decimal fract is found */

		/* len of rest of header strings other than group names */
#define H 10
#define RANKSTR " %8.1f"

			/* header for data echo */
char colhead[FMTSIZ];
int headlen, undercnt;
#define UNDERLINE '_'


/* node of binary tree for ranking data in nonparametric stat tests */

typedef struct datanode {
	float data;
	struct datanode *next;
} DNODE;

typedef struct hashtable {
	char *hkey;
	int cnt;
	struct datanode *startlist, *endlist;
} TABLE;

		/* a silly number which makes the hash table work better */
#define MAGIC 5


/* tabsiz is size of has table which keeps track of group strings and
	ptr to link list of each group's data. tabsiz should always
	be a prime number */
#define TABSIZ 53
TABLE table[TABSIZ];


char *notequal="WARNING:COUNTS UNEQUAL:%s=%d %s=%d\n\t\tCan't do stats on these groups\n";

wmp()
{
	int cmp();

			/* sort the htable for alphabetical output */
	qsort(table, TABSIZ, sizeof(TABLE), cmp);
	pair_test();	 /* wmp test all combinations of pairs */
}

pair_test()
{
	register int j; 
	register DNODE *d1, *d2;
	int i, ndiff, nneg, npos, fewernegs, negsign;
	RNODE *root;
	double diff, T;
	double tmp, get_rank();



		/* eat up the leading empty hash table elements */
	for(i=0; i < TABSIZ && !(DATALIST(i)); i++)
		;


		/* now do all combinations of twos thru the hash table */
	for(; i < TABSIZ; i++) {
		for(j=i+1; j < TABSIZ; j++){
			TRACEF(("processing %s %s\n", HASHSTR(i),HASHSTR(j)));
			root = NULL;
			npos = nneg = ndiff = 0;
			T = 0.0;

			if (table[i].cnt != table[j].cnt) {
				printf(notequal, HASHSTR(i),table[i].cnt,HASHSTR(j), table[j].cnt);
				continue;
			}

			/* construct rank tree of the differences */
			for(d1=DATALIST(i),d2=DATALIST(j); d1; d1=d1->next, d2=d2->next) {
				diff = d1->data - d2->data;
				if (diff == 0.0)
					continue;
				++ndiff;	/* count non zero diffs */
				if((negsign=(diff < 0.0)))
					++nneg;
				else
					++npos;
				mkranks(&root, ABS(negsign,diff));
			}

			TRACEF(("negcnt=%d poscnt=%d notzero=%d\n",nneg,npos,ndiff));
				/* change root->ties to root->rank */
			rank(root);

			fewernegs = (nneg < npos);

			printf(header, HASHSTR(i), HASHSTR(j));
			if(usr.title)
				printf("TITLE:%s\n", usr.title);
			if(usr.echo) {
				printf(colhead,HASHSTR(i),HASHSTR(j),"diff.","rank(diff)");
				underline();
			}


				/* get the smaller of the + or - diffs */
			for(d1=DATALIST(i),d2=DATALIST(j); d1; d1=d1->next, d2=d2->next) {
				diff = d1->data - d2->data;
				if(usr.echo) 
					printf(fmt, d1->data, d2->data, diff);
				if(diff == 0.0) {
					if(usr.echo)
						putc('\n',stdout);
					continue;
				}

				tmp = get_rank(root, ABS(diff < 0.0, diff));

				if(usr.echo) 
					printf(RANKSTR, tmp);

				if((diff > 0.0 && !fewernegs)
					|| (diff < 0.0 && fewernegs)) {
						if(usr.echo) {
							printf(" +");
							if(T == 0.0)
								printf(" ('+'=rank used in T)");
						}
						T += tmp;
				}
				if(usr.echo)
					putc('\n',stdout);
			}

			if(usr.echo)
				underline();
			significant(fewernegs,HASHSTR(i), HASHSTR(j), ndiff, T);

			myfree();	/* free the rank tree */

		}
	}
}


underline() {
	for(undercnt=headlen;  undercnt--;)
		putc(UNDERLINE,stdout);
	putc('\n',stdout);
}


filltable(fp)
register FILE *fp;
{
	register char *c;
	char *alpha, *number;	/* ptrs to alpha & num strs in input */
	char *badeod = "unexpected end of data\n";
	double x;			/* usr datum after sscanf conv */
	int hashdata(), sscanf();
	int maxright=0, len, strlen=0, numlen=0;

	while (getdata(&alpha,fp) != EOF){
		switch(usr.label){
			case ON:	if(getdata(&number,fp) == EOF)
						err(badeod);
					break;

			case OFF:	number = alpha;
					alpha = usr.group;
					break;

			case AUTO:	number = alpha;
					alpha = usr.fname;
					break;
		} /* switch */

		if(usr.echo) {	/* calc len of whole and fract part of data */
			for(c=number; *c; ++c) {
				if(*c == '.'){
					++c;	/* put ptr 1 past decimal */
					for(len=0; *c; ++len, ++c)
						;
					if(len > maxright)
						maxright = len;
					break;
				}
			}
		}
		if(c-number > numlen)
			numlen = c - number;

		for(c=alpha; *c; ++c)
			;
		if(c - alpha > strlen)
			strlen = c - alpha + 2;
			

		if (sscanf(number, "%F", &x) != 1)
			err("bad data \"%s %s\"\n",alpha,number);

		hashdata(alpha, x, table, TABSIZ);
	} /* while reading data */

	if(!usr.echo)
		return;
	if(numlen > strlen)
		strlen = numlen;
	sprintf(fmt, "%%%d.%df%%%d.%df %%%d.%df", strlen, maxright, strlen, maxright, H-2, maxright);
	sprintf(colhead,"%%%ds%%%ds%%%ds  %%%ds\n",strlen, strlen, H, H);
	headlen = 2 + strlen * 2 + H * 2; 
	TRACEF(("max fraction len=%d\ \tfmt=%s \tcolhead=%s\n", maxright,fmt,colhead));
}

#ifdef TEST
		/* debug-development dump */
tabledump(){	
	register int i;
	register DNODE *dnode;

	printf("\n\nTABLEDUMP\n");
	for(i=0; i < TABSIZ; i++) {
		if (table[i].hkey){
			printf("hkey=%s cnt=%d ", table[i].hkey, table[i].cnt);
			for(dnode=table[i].startlist; dnode; dnode=dnode->next)
				printf("\t%g ", dnode->data);
		}
		printf("\n");
	}
	printf("\nENDDUMP\n\n");
}
#endif

#define MAXALLOWED 4 / 5
int hashdata(str, x, table, tabsiz)
char *str;
double x;
TABLE *table;
int tabsiz;
{
	register int hval=0;
	register int displace=1;
	register TABLE *tbl;
	TABLE *endtable=table+tabsiz;
	int strcmp();
	char *c=str;
	char *strsave(), *malloc();
	static char *nospace="hash:nospace";
	static int ntable=0;
	int i=13;

	while(*c) {
		hval += *c++ * i;
		i *= MAGIC;
	}

	if (hval < 0)
		hval = -hval;

	tbl = table + (hval % tabsiz);

	if (tbl < table || tbl >= endtable)
		err("htab botch");


	for(;;){
		if ( !(tbl->hkey) ) {			/* at empty hole */
			if ( ++ntable > tabsiz * MAXALLOWED)
				err("htab full");
			tbl->cnt = 1;
			if (!(tbl->hkey = strsave (str)))
				err(nospace);
			if(!(tbl->startlist=tbl->endlist=(DNODE *)malloc(sizeof(DNODE))))
				err(nospace);
			tbl->startlist->data = x; 
			break;
		}

		if (!(strcmp(tbl->hkey,str))) {		/* found */
			tbl->cnt++;	
			if(!(tbl->endlist->next=(DNODE *)malloc(sizeof(DNODE))))
				err(nospace);
			tbl->endlist = tbl->endlist->next;
			tbl->endlist->data = x;
			return;
		}

		else {				/* collision, quad srch */
			tbl += displace;
			displace += 2;
			if (tbl >= endtable) 
				tbl -= tabsiz;
		}
	}
}

int cmp(arg1, arg2)
TABLE *arg1, *arg2;
{
	register int cmpval;
	int strcmp();

	if (!(cmpval = strcmp(arg1->hkey, arg2->hkey) ))
		return(0);	/* equality */

	return( (cmpval > 0) ? (1) : (-1) );
}
